/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.hyperlink;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;

public class FixBuildToolsVersionHyperlink
extends NotificationHyperlink {
    private final VirtualFile myBuildFile;
    private final String myVersion;

    public FixBuildToolsVersionHyperlink(VirtualFile buildFile, String version) {
        super("fix.build.tools.version", "Update Build Tools version and sync project");
        this.myBuildFile = buildFile;
        this.myVersion = version;
    }

    @Override
    protected void execute(Project project) {
        FixBuildToolsVersionHyperlink.fixBuildToolsVersionAndSync(project, this.myBuildFile, this.myVersion);
    }

    static void fixBuildToolsVersionAndSync(Project project, VirtualFile buildFile, final String version) {
        final GradleBuildFile gradleBuildFile = new GradleBuildFile(buildFile, project);
        Object pluginVersion = gradleBuildFile.getValue(BuildFileKey.BUILD_TOOLS_VERSION);
        if (pluginVersion != null) {
            WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

                @Override
                public void run() {
                    gradleBuildFile.setValue(BuildFileKey.BUILD_TOOLS_VERSION, version);
                }
            });
            GradleProjectImporter.getInstance().requestProjectSync(project, null);
        }
    }
}

