/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.FixGradleModelVersionHyperlink;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import java.util.List;

public class UnsupportedModelVersionErrorHandler
extends AbstractSyncErrorHandler {
    public static final String UNSUPPORTED_MODEL_VERSION_ERROR_PREFIX = "The project is using an unsupported version of the Android Gradle plug-in";
    public static final String READ_MIGRATION_GUIDE_MSG = "Please read the migration guide";

    @Override
    public boolean handleError(List<String> message, ExternalSystemException error, NotificationData notification, Project project) {
        String msg = error.getMessage();
        if (msg.startsWith(UNSUPPORTED_MODEL_VERSION_ERROR_PREFIX)) {
            boolean openMigrationGuide = msg.contains(READ_MIGRATION_GUIDE_MSG);
            UnsupportedModelVersionErrorHandler.updateNotification(notification, project, msg, new FixGradleModelVersionHyperlink(openMigrationGuide));
            return true;
        }
        return false;
    }
}

