/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.quickfix;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.quickfix.AbstractGradleAwareFix;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;

public class GradleIncreaseLanguageLevelFix
extends AbstractGradleAwareFix {
    private static final Logger LOG = Logger.getInstance(GradleIncreaseLanguageLevelFix.class);
    private final LanguageLevel myLevel;
    private final GradleBuildFile myBuildFile;

    public GradleIncreaseLanguageLevelFix(LanguageLevel targetLevel, GradleBuildFile buildFile) {
        this.myLevel = targetLevel;
        this.myBuildFile = buildFile;
    }

    public String getText() {
        return CodeInsightBundle.message((String)"set.language.level.to.0", (Object[])new Object[]{this.myLevel.getPresentableText()});
    }

    public String getFamilyName() {
        return CodeInsightBundle.message((String)"set.language.level", (Object[])new Object[0]);
    }

    private static boolean isJdkSupportsLevel(Sdk jdk, LanguageLevel level) {
        if (jdk == null) {
            return true;
        }
        String versionString = jdk.getVersionString();
        JavaSdkVersion version = versionString == null ? null : JdkVersionUtil.getVersion((String)versionString);
        return version != null && version.getMaxLanguageLevel().isAtLeast(level);
    }

    public boolean isAvailable(Project project, Editor editor, PsiFile file) {
        if (file == null) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        return module != null && GradleIncreaseLanguageLevelFix.isLanguageLevelAcceptable(project, module, this.myLevel);
    }

    private static boolean isLanguageLevelAcceptable(Project project, Module module, LanguageLevel level) {
        return GradleIncreaseLanguageLevelFix.isJdkSupportsLevel(GradleIncreaseLanguageLevelFix.getRelevantJdk(project, module), level);
    }

    public void invoke(final Project project, Editor editor, PsiFile file) {
        if (file == null) {
            return;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        final Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        final LanguageLevel moduleLevel = module == null ? null : LanguageLevelModuleExtensionImpl.getInstance((Module)module).getLanguageLevel();
        GradleIncreaseLanguageLevelFix.runWriteCommandActionAndSync(project, new Runnable(){

            @Override
            public void run() {
                if (moduleLevel != null && GradleIncreaseLanguageLevelFix.isLanguageLevelAcceptable(project, module, GradleIncreaseLanguageLevelFix.this.myLevel)) {
                    String gradleJavaVersion = GradleIncreaseLanguageLevelFix.getGradleJavaVersionString(GradleIncreaseLanguageLevelFix.this.myLevel);
                    if (GradleUtil.getAndroidProject(module) != null) {
                        GradleIncreaseLanguageLevelFix.this.myBuildFile.setValue(BuildFileKey.SOURCE_COMPATIBILITY, gradleJavaVersion);
                        GradleIncreaseLanguageLevelFix.this.myBuildFile.setValue(BuildFileKey.TARGET_COMPATIBILITY, gradleJavaVersion);
                    } else {
                        LOG.error("Setting language level on Java module is not supported");
                    }
                    AbstractGradleAwareFix.registerUndoAction(project);
                } else {
                    LOG.error("Tried to set language level without specify a module");
                }
            }
        }, null);
    }

    private static Sdk getRelevantJdk(Project project, Module module) {
        Sdk projectJdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        Sdk moduleJdk = module == null ? null : ModuleRootManager.getInstance((Module)module).getSdk();
        return moduleJdk == null ? projectJdk : moduleJdk;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static String getGradleJavaVersionString(LanguageLevel languageLevel) {
        return "JavaVersion." + languageLevel.name().replaceAll("JDK", "VERSION");
    }
}

