/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.quickfix;

import com.android.tools.idea.gradle.dsl.dependencies.ExternalDependencySpec;
import com.android.tools.idea.gradle.quickfix.AbstractGradleDependencyFix;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;

public class AddGradleJUnitDependencyFix
extends AbstractGradleDependencyFix {
    private final String myClassName;
    private final boolean myIsJunit4;

    public AddGradleJUnitDependencyFix(Module module, PsiReference reference, String className, boolean isJunit4) {
        super(module, reference);
        this.myClassName = className;
        this.myIsJunit4 = isJunit4;
    }

    public String getText() {
        return QuickFixBundle.message((String)"orderEntry.fix.add.junit.jar.to.classpath", (Object[])new Object[0]);
    }

    public void invoke(final Project project, Editor editor, PsiFile file) {
        ExternalDependencySpec newDependency = new ExternalDependencySpec("junit", "junit", "3.8.1");
        if (this.myIsJunit4) {
            newDependency.version = "4.12";
        }
        String configurationName = AddGradleJUnitDependencyFix.getConfigurationName(this.myModule, AddGradleJUnitDependencyFix.isTestScope(this.myModule, this.myReference));
        this.addDependencyAndSync(configurationName, newDependency, new Computable<PsiClass[]>(){

            public PsiClass[] compute() {
                PsiClass[] psiClassArray;
                PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(AddGradleJUnitDependencyFix.this.myClassName, GlobalSearchScope.moduleWithLibrariesScope((Module)AddGradleJUnitDependencyFix.this.myModule));
                if (aClass != null) {
                    PsiClass[] psiClassArray2 = new PsiClass[1];
                    psiClassArray = psiClassArray2;
                    psiClassArray2[0] = aClass;
                } else {
                    psiClassArray = null;
                }
                return psiClassArray;
            }
        }, editor);
    }
}

