/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.Variant;
import com.android.sdklib.repository.FullRevision;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.stats.UsageTracker;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Set;

class ProjectStructureUsageTracker {
    private final Project myProject;

    ProjectStructureUsageTracker(Project project) {
        this.myProject = project;
    }

    void trackProjectStructure() {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                ModuleManager moduleManager = ModuleManager.getInstance((Project)ProjectStructureUsageTracker.this.myProject);
                ProjectStructureUsageTracker.this.trackProjectStructure(moduleManager.getModules());
            }
        });
    }

    private void trackProjectStructure(Module[] modules) {
        AndroidGradleModel target;
        AndroidGradleModel appModel = null;
        AndroidGradleModel libModel = null;
        for (Module module : modules) {
            AndroidGradleModel androidModel = AndroidGradleModel.get(module);
            if (androidModel == null) continue;
            AndroidProject androidProject = androidModel.getAndroidProject();
            if (androidProject.isLibrary()) {
                libModel = androidModel;
                continue;
            }
            appModel = androidModel;
            ProjectStructureUsageTracker.trackExternalDependenciesInAndroidApp(androidProject);
        }
        AndroidGradleModel androidGradleModel = target = appModel != null ? appModel : libModel;
        if (target != null) {
            AndroidProject androidProject = target.getAndroidProject();
            FullRevision gradleVersion = GradleUtil.getGradleVersion(this.myProject);
            UsageTracker.getInstance().trackGradleArtifactVersions(target.getApplicationId(), androidProject.getModelVersion(), gradleVersion != null ? gradleVersion.toString() : "<Not Found>");
        }
    }

    private static void trackExternalDependenciesInAndroidApp(AndroidProject model) {
        Collection variants = model.getVariants();
        if (variants.isEmpty()) {
            return;
        }
        Variant chosen = null;
        for (Variant variant : variants) {
            if (!"release".equals(variant.getBuildType())) continue;
            chosen = variant;
            break;
        }
        if (chosen == null) {
            chosen = (Variant)ContainerUtil.getFirstItem((Collection)variants);
        }
        if (chosen != null) {
            ProjectStructureUsageTracker.trackLibraryCount(chosen);
        }
    }

    private static void trackLibraryCount(Variant variant) {
        DependencyFiles files = new DependencyFiles();
        AndroidArtifact artifact = variant.getMainArtifact();
        String applicationId = artifact.getApplicationId();
        Dependencies dependencies = artifact.getDependencies();
        for (JavaLibrary javaLibrary : dependencies.getJavaLibraries()) {
            ProjectStructureUsageTracker.addJarLibraryAndDependencies(javaLibrary, files);
        }
        for (AndroidLibrary androidLibrary : dependencies.getLibraries()) {
            ProjectStructureUsageTracker.addAarLibraryAndDependencies(androidLibrary, files);
        }
        UsageTracker.getInstance().trackLibraryCount(applicationId, files.jars.size(), files.aars.size());
    }

    private static void addJarLibraryAndDependencies(JavaLibrary javaLibrary, DependencyFiles files) {
        File jarFile = javaLibrary.getJarFile();
        if (files.jars.contains(jarFile)) {
            return;
        }
        files.jars.add(jarFile);
        for (JavaLibrary dependency : javaLibrary.getDependencies()) {
            ProjectStructureUsageTracker.addJarLibraryAndDependencies(dependency, files);
        }
    }

    private static void addAarLibraryAndDependencies(AndroidLibrary androidLibrary, DependencyFiles files) {
        String gradlePath = androidLibrary.getProject();
        if (StringUtil.isEmpty((String)gradlePath)) {
            File file = androidLibrary.getJarFile();
            if (files.aars.contains(file)) {
                return;
            }
            files.aars.add(file);
            for (AndroidLibrary library : androidLibrary.getLibraryDependencies()) {
                ProjectStructureUsageTracker.addAarLibraryAndDependencies(library, files);
            }
        }
    }

    private static class DependencyFiles {
        final Set<File> aars = Sets.newHashSet();
        final Set<File> jars = Sets.newHashSet();

        private DependencyFiles() {
        }
    }
}

