/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.builder.model.AndroidProject;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Map;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;

public class ProjectImportAction
implements BuildAction<AllModels>,
Serializable {
    private static final String ANDROID_TASK_NAME_PREFIX = "android";

    public AllModels execute(BuildController controller) {
        IdeaProject ideaProject = (IdeaProject)controller.getModel(IdeaProject.class);
        if (ideaProject == null || ideaProject.getModules().isEmpty()) {
            return null;
        }
        AllModels allModels = new AllModels(ideaProject);
        for (IdeaModule module : ideaProject.getModules()) {
            if (!ProjectImportAction.isAndroidProject(module)) continue;
            AndroidProject androidProject = (AndroidProject)controller.getModel((Model)module, AndroidProject.class);
            allModels.addAndroidProject(androidProject, module);
        }
        return allModels.hasAndroidProjects() ? allModels : null;
    }

    private static boolean isAndroidProject(IdeaModule module) {
        for (GradleTask task : module.getGradleProject().getTasks()) {
            String taskName = task.getName();
            if (taskName == null || !taskName.startsWith(ANDROID_TASK_NAME_PREFIX)) continue;
            return true;
        }
        return false;
    }

    public static class AllModels
    implements Serializable {
        private final Map<String, AndroidProject> androidProjectsByPath = Maps.newHashMap();
        private final IdeaProject myIdeaProject;

        public AllModels(IdeaProject project) {
            this.myIdeaProject = project;
        }

        public IdeaProject getIdeaProject() {
            return this.myIdeaProject;
        }

        public void addAndroidProject(AndroidProject project, IdeaModule module) {
            this.androidProjectsByPath.put(AllModels.extractMapKey(module), project);
        }

        public AndroidProject getAndroidProject(IdeaModule module) {
            return this.androidProjectsByPath.get(AllModels.extractMapKey(module));
        }

        private static String extractMapKey(IdeaModule module) {
            return module.getGradleProject().getPath();
        }

        public boolean hasAndroidProjects() {
            return !this.androidProjectsByPath.isEmpty();
        }
    }
}

