/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.sdklib.repository.FullRevision;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.ChooseGradleHomeDialog;
import com.android.tools.idea.gradle.project.ProxySettingsDialog;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenProjectStructureHyperlink;
import com.android.tools.idea.gradle.util.GradleProperties;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.util.ProxySettings;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.startup.AndroidStudioInitializer;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.net.HttpConfigurable;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

final class PreSyncChecks {
    private static final Logger LOG = Logger.getInstance(PreSyncChecks.class);
    private static final String GRADLE_SYNC_MSG_TITLE = "Gradle Sync";
    private static final String PROJECT_SYNCING_ERROR_GROUP = "Project syncing error";

    private PreSyncChecks() {
    }

    static PreSyncCheckResult canSync(Project project) {
        boolean usingWrapper;
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return PreSyncCheckResult.success();
        }
        if (AndroidStudioInitializer.isAndroidStudio()) {
            Sdk jdk = IdeSdks.getJdk();
            if (jdk == null || !ExternalSystemJdkUtil.checkForJdk((Project)project, (String)jdk.getName())) {
                AndroidGradleNotification.getInstance(project).showBalloon("Invalid Project JDK", "Please choose a valid JDK directory", NotificationType.ERROR, OpenProjectStructureHyperlink.openJdkSettings(project));
                return PreSyncCheckResult.failure("Invalid Project Jdk");
            }
            PreSyncChecks.checkHttpProxySettings(project);
        }
        ProjectSyncMessages syncMessages = ProjectSyncMessages.getInstance(project);
        syncMessages.removeMessages(PROJECT_SYNCING_ERROR_GROUP);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            GradleUtil.attemptToUseEmbeddedGradle(project);
        }
        GradleProjectSettings gradleSettings = GradleUtil.getGradleProjectSettings(project);
        File wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project);
        DistributionType distributionType = gradleSettings != null ? gradleSettings.getDistributionType() : null;
        boolean bl = usingWrapper = (distributionType == null || distributionType == DistributionType.DEFAULT_WRAPPED) && wrapperPropertiesFile != null;
        if (usingWrapper && gradleSettings != null) {
            gradleSettings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
        } else if (!ApplicationManager.getApplication().isUnitTestMode() && wrapperPropertiesFile == null && gradleSettings != null) {
            PreSyncChecks.createWrapperIfNecessary(project, gradleSettings, distributionType);
        }
        return PreSyncCheckResult.success();
    }

    private static void checkHttpProxySettings(Project project) {
        HttpConfigurable ideHttpProxySettings = HttpConfigurable.getInstance();
        if (ideHttpProxySettings.USE_HTTP_PROXY && StringUtil.isNotEmpty((String)ideHttpProxySettings.PROXY_HOST)) {
            GradleProperties properties;
            try {
                properties = new GradleProperties(project);
            }
            catch (IOException e) {
                LOG.info("Failed to read gradle.properties file", (Throwable)e);
                return;
            }
            ProxySettings gradleProxySettings = properties.getHttpProxySettings();
            ProxySettings ideProxySettings = new ProxySettings(ideHttpProxySettings);
            if (!ideProxySettings.equals(gradleProxySettings)) {
                ProxySettingsDialog dialog = new ProxySettingsDialog(project, ideProxySettings);
                dialog.show();
                if (dialog.getExitCode() == 0) {
                    dialog.applyProxySettings(properties.getProperties());
                    try {
                        properties.save();
                    }
                    catch (IOException e) {
                        Throwable root = ExceptionUtil.getRootCause((Throwable)e);
                        String cause = root.getMessage();
                        String errMsg = "Failed to save changes to gradle.properties file.";
                        if (StringUtil.isNotEmpty((String)cause)) {
                            if (!cause.endsWith(".")) {
                                cause = cause + ".";
                            }
                            errMsg = errMsg + String.format("\nCause: %1$s", cause);
                        }
                        AndroidGradleNotification notification = AndroidGradleNotification.getInstance(project);
                        notification.showBalloon("Proxy Settings", errMsg, NotificationType.ERROR);
                        LOG.info("Failed to save changes to gradle.properties file", (Throwable)e);
                    }
                }
            }
        }
    }

    private static boolean createWrapperIfNecessary(Project project, GradleProjectSettings gradleSettings, DistributionType distributionType) {
        ChooseGradleHomeDialog dialog;
        boolean createWrapper = false;
        boolean chooseLocalGradleHome = false;
        if (distributionType == null) {
            String msg = PreSyncChecks.createUseWrapperQuestion("Gradle settings for this project are not configured yet.");
            int answer = Messages.showOkCancelDialog((Project)project, (String)msg, (String)GRADLE_SYNC_MSG_TITLE, (Icon)Messages.getQuestionIcon());
            createWrapper = answer == 0;
        } else if (distributionType == DistributionType.DEFAULT_WRAPPED) {
            createWrapper = true;
        } else if (distributionType == DistributionType.LOCAL) {
            String gradleHome = gradleSettings.getGradleHome();
            String msg = null;
            if (StringUtil.isEmpty((String)gradleHome)) {
                msg = PreSyncChecks.createUseWrapperQuestion("The path of the local Gradle distribution to use is not set.");
            } else {
                File gradleHomePath = new File(FileUtil.toSystemDependentName((String)gradleHome));
                if (!gradleHomePath.isDirectory()) {
                    String reason = String.format("The path\n'%1$s'\n, set as a local Gradle distribution, does not belong to an existing directory.", gradleHomePath.getPath());
                    msg = PreSyncChecks.createUseWrapperQuestion(reason);
                } else {
                    FullRevision gradleVersion = GradleUtil.getGradleVersion(gradleHomePath);
                    if (gradleVersion == null) {
                        String reason = String.format("The path\n'%1$s'\n, does not belong to a Gradle distribution.", gradleHomePath.getPath());
                        msg = PreSyncChecks.createUseWrapperQuestion(reason);
                    } else if (!GradleUtil.isSupportedGradleVersion(gradleVersion)) {
                        String reason = String.format("Gradle version %1$s is not supported.", gradleHomePath.getPath());
                        msg = PreSyncChecks.createUseWrapperQuestion(reason);
                    }
                }
            }
            if (msg != null) {
                int answer = Messages.showOkCancelDialog((Project)project, (String)msg, (String)GRADLE_SYNC_MSG_TITLE, (Icon)Messages.getQuestionIcon());
                createWrapper = answer == 0;
                boolean bl = chooseLocalGradleHome = !createWrapper;
            }
        }
        if (createWrapper) {
            File projectDirPath = Projects.getBaseDirPath(project);
            File gradleDirPath = new File(projectDirPath, "gradle");
            if (!FileUtil.delete((File)gradleDirPath)) {
                return true;
            }
            try {
                GradleUtil.createGradleWrapper(projectDirPath);
                if (distributionType == null) {
                    gradleSettings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
                }
                return true;
            }
            catch (IOException e) {
                LOG.info("Failed to create Gradle wrapper for project '" + project.getName() + "'", (Throwable)e);
            }
        } else if ((distributionType == null || chooseLocalGradleHome) && (dialog = new ChooseGradleHomeDialog()).showAndGet()) {
            String enteredGradleHomePath = dialog.getEnteredGradleHomePath();
            gradleSettings.setGradleHome(enteredGradleHomePath);
            gradleSettings.setDistributionType(DistributionType.LOCAL);
            return true;
        }
        return false;
    }

    private static String createUseWrapperQuestion(String reason) {
        return reason + "\n\n" + "Would you like the project to use the Gradle wrapper?\n" + "(The wrapper will automatically download the latest supported Gradle version).\n\n" + "Click 'OK' to use the Gradle wrapper, or 'Cancel' to manually set the path of a local Gradle distribution.";
    }

    static class PreSyncCheckResult {
        private final boolean mySuccess;
        private final String myFailureCause;

        private static PreSyncCheckResult success() {
            return new PreSyncCheckResult(true, null);
        }

        private static PreSyncCheckResult failure(String cause) {
            return new PreSyncCheckResult(false, cause);
        }

        private PreSyncCheckResult(boolean success, String failureCause) {
            this.mySuccess = success;
            this.myFailureCause = failureCause;
        }

        public boolean isSuccess() {
            return this.mySuccess;
        }

        public String getFailureCause() {
            return this.myFailureCause;
        }
    }
}

