/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.parser.GradleSettingsFile;
import com.android.tools.idea.gradle.project.GradleProjectDependencyParser;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.GradleSiblingLookup;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.project.ModuleImporter;
import com.android.tools.idea.gradle.project.ModuleToImport;
import com.android.tools.idea.gradle.project.ProjectImportUtil;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class GradleModuleImporter
extends ModuleImporter {
    private final Logger LOG = Logger.getInstance(this.getClass());
    private final Project myProject;
    private final boolean myIsWizard;

    public GradleModuleImporter(WizardContext context) {
        this(context.getProject(), true);
    }

    public GradleModuleImporter(Project project) {
        this(project, false);
    }

    private GradleModuleImporter(Project project, boolean isWizard) {
        this.myIsWizard = isWizard;
        this.myProject = project;
    }

    public static boolean isGradleProject(VirtualFile importSource) {
        VirtualFile target = ProjectImportUtil.findImportTarget(importSource);
        return target != null && "gradle".equals(target.getExtension());
    }

    @Override
    public boolean isStepVisible(ModuleWizardStep step) {
        return false;
    }

    @Override
    public List<? extends ModuleWizardStep> createWizardSteps() {
        return Collections.emptyList();
    }

    @Override
    public void importProjects(Map<String, VirtualFile> projects) {
        try {
            GradleModuleImporter.importModules(this, projects, this.myProject, null);
        }
        catch (IOException e) {
            this.LOG.error((Throwable)e);
        }
        catch (ConfigurationException e) {
            this.LOG.error((Throwable)e);
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean canImport(VirtualFile importSource) {
        try {
            return GradleModuleImporter.isGradleProject(importSource) && (this.myIsWizard || this.findModules(importSource).size() == 1);
        }
        catch (IOException e) {
            this.LOG.error((Throwable)e);
            return false;
        }
    }

    @Override
    public Set<ModuleToImport> findModules(VirtualFile importSource) throws IOException {
        assert (this.myProject != null);
        return GradleModuleImporter.getRelatedProjects(importSource, this.myProject);
    }

    public static Set<ModuleToImport> getRelatedProjects(VirtualFile sourceProject, Project destinationProject) {
        VirtualFile settingsGradle = sourceProject.findFileByRelativePath("settings.gradle");
        if (settingsGradle != null) {
            return GradleModuleImporter.buildModulesSet(GradleModuleImporter.getSubProjects(settingsGradle, destinationProject), GradleProjectDependencyParser.newInstance(destinationProject));
        }
        return GradleModuleImporter.getRequiredProjects(sourceProject, destinationProject);
    }

    private static Set<ModuleToImport> getRequiredProjects(VirtualFile sourceProject, Project destinationProject) {
        GradleSiblingLookup subProjectLocations = new GradleSiblingLookup(sourceProject, destinationProject);
        Function<VirtualFile, Iterable<String>> parser = GradleProjectDependencyParser.newInstance(destinationProject);
        HashMap modules = Maps.newHashMap();
        LinkedList toAnalyze = Lists.newLinkedList();
        toAnalyze.add(sourceProject);
        while (!toAnalyze.isEmpty()) {
            HashSet dependencies = Sets.newHashSet((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)toAnalyze, parser)));
            Iterable notAnalyzed = Iterables.filter((Iterable)dependencies, (Predicate)Predicates.not((Predicate)Predicates.in(modules.keySet())));
            HashMap dependencyToLocation = Maps.newHashMap();
            for (String dependency : notAnalyzed) {
                dependencyToLocation.put(dependency, subProjectLocations.apply(dependency));
            }
            modules.putAll(dependencyToLocation);
            toAnalyze = FluentIterable.from(dependencyToLocation.values()).filter(Predicates.notNull()).toList();
        }
        modules.put(subProjectLocations.getPrimaryProjectName(), sourceProject);
        return GradleModuleImporter.buildModulesSet(modules, parser);
    }

    private static Set<ModuleToImport> buildModulesSet(Map<String, VirtualFile> modules, Function<VirtualFile, Iterable<String>> parser) {
        com.intellij.util.containers.HashSet modulesSet = new com.intellij.util.containers.HashSet(modules.size());
        for (Map.Entry<String, VirtualFile> entry : modules.entrySet()) {
            VirtualFile location = entry.getValue();
            Supplier dependencyComputer = location != null ? Suppliers.compose(parser, (Supplier)Suppliers.ofInstance((Object)location)) : Suppliers.ofInstance((Object)ImmutableSet.of());
            modulesSet.add(new ModuleToImport(entry.getKey(), location, (Supplier<? extends Iterable<String>>)dependencyComputer));
        }
        return modulesSet;
    }

    public static Map<String, VirtualFile> getSubProjects(VirtualFile settingsGradle, Project destinationProject) {
        GradleSettingsFile settingsFile = new GradleSettingsFile(settingsGradle, destinationProject);
        Map<String, File> allProjects = settingsFile.getModulesWithLocation();
        return Maps.transformValues(allProjects, (Function)new ResolvePath(VfsUtilCore.virtualToIoFile((VirtualFile)settingsGradle.getParent())));
    }

    @VisibleForTesting
    static void importModules(final Object requestor, final Map<String, VirtualFile> modules, final Project project, final GradleSyncListener listener) throws IOException, ConfigurationException {
        String error = GradleModuleImporter.validateProjectsForImport(modules);
        if (error != null) {
            if (listener != null && project != null) {
                listener.syncFailed(project, error);
                return;
            }
            throw new IOException(error);
        }
        assert (project != null);
        Throwable throwable = new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Throwable {
                GradleModuleImporter.copyAndRegisterModule(requestor, modules, project, listener);
            }

            public boolean isSilentExecution() {
                return true;
            }
        }.execute().getThrowable();
        GradleModuleImporter.rethrowAsProperlyTypedException(throwable);
    }

    private static String validateProjectsForImport(Map<String, VirtualFile> modules) {
        TreeSet<String> projects = new TreeSet<String>();
        for (Map.Entry<String, VirtualFile> mapping : modules.entrySet()) {
            if (mapping.getValue() != null) continue;
            projects.add(mapping.getKey());
        }
        if (projects.isEmpty()) {
            return null;
        }
        if (projects.size() == 1) {
            return String.format("Sources for module '%1$s' were not found", Iterables.getFirst(projects, null));
        }
        String projectsList = Joiner.on((String)"', '").join(projects);
        return String.format("Sources were not found for modules '%1$s'", projectsList);
    }

    private static void rethrowAsProperlyTypedException(Throwable throwable) throws IOException, ConfigurationException {
        if (throwable != null) {
            Throwables.propagateIfPossible((Throwable)throwable, IOException.class, ConfigurationException.class);
            throw new IllegalStateException(throwable);
        }
    }

    private static void copyAndRegisterModule(Object requestor, Map<String, VirtualFile> modules, Project project, GradleSyncListener listener) throws IOException, ConfigurationException {
        VirtualFile projectRoot = project.getBaseDir();
        if (projectRoot.findChild("settings.gradle") == null) {
            projectRoot.createChildData(requestor, "settings.gradle");
        }
        GradleSettingsFile gradleSettingsFile = GradleSettingsFile.get(project);
        assert (gradleSettingsFile != null) : "File should have been created";
        for (Map.Entry<String, VirtualFile> module : modules.entrySet()) {
            String name = module.getKey();
            File targetFile = GradleUtil.getModuleDefaultPath(projectRoot, name);
            VirtualFile moduleSource = module.getValue();
            if (moduleSource != null) {
                if (!VfsUtilCore.isAncestor((VirtualFile)projectRoot, (VirtualFile)moduleSource, (boolean)true)) {
                    VirtualFile target = VfsUtil.createDirectoryIfMissing((String)targetFile.getAbsolutePath());
                    if (target == null) {
                        throw new IOException(String.format("Unable to create directory %1$s", targetFile));
                    }
                    if (target.exists()) {
                        target.delete(requestor);
                    }
                    moduleSource.copy(requestor, target.getParent(), target.getName());
                } else {
                    targetFile = VfsUtilCore.virtualToIoFile((VirtualFile)moduleSource);
                }
            }
            gradleSettingsFile.addModule(name, targetFile);
        }
        GradleProjectImporter.getInstance().requestProjectSync(project, false, listener);
    }

    private static class ResolvePath
    implements Function<File, VirtualFile> {
        private final File mySourceDir;

        public ResolvePath(File sourceDir) {
            this.mySourceDir = sourceDir;
        }

        public VirtualFile apply(File path) {
            if (!path.isAbsolute()) {
                path = new File(this.mySourceDir, path.getPath());
            }
            return VfsUtil.findFileByIoFile((File)path, (boolean)true);
        }
    }
}

