/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.parser;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.GradleGroovyFile;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public abstract class ValueFactory<E> {
    public List<E> getValues(GrStatementOwner closure) {
        ArrayList result = Lists.newArrayList();
        for (PsiElement element : closure.getChildren()) {
            List<E> values = this.getValues(element);
            if (values == null || values.isEmpty()) continue;
            result.addAll(values);
        }
        return result;
    }

    public void setValues(GrStatementOwner closure, List<E> values, KeyFilter filter) {
        for (E value : values) {
            this.setValue(closure, value, filter);
        }
        for (E existingValue : this.findValuesToDelete(closure, values)) {
            this.removeValue(closure, existingValue);
        }
        GradleGroovyFile.reformatClosure(closure);
    }

    protected Iterable<E> findValuesToDelete(GrStatementOwner closure, final List<E> replacementValues) {
        return Iterables.filter(this.getValues(closure), (Predicate)new Predicate<E>(){

            public boolean apply(E input) {
                return !replacementValues.contains(input);
            }
        });
    }

    public E parse(String s, Project project) {
        throw new UnsupportedOperationException("parse not implemented");
    }

    protected abstract void setValue(GrStatementOwner var1, E var2, KeyFilter var3);

    protected abstract List<E> getValues(PsiElement var1);

    protected void removeValue(GrStatementOwner closure, E value) {
        throw new UnsupportedOperationException("removeValue not implemented");
    }

    public static interface KeyFilter {
        public boolean shouldWriteKey(BuildFileKey var1, Object var2);
    }
}

