/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.model.java;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.idea.IdeaContentRoot;
import org.gradle.tooling.model.idea.IdeaSourceDirectory;
import org.jetbrains.plugins.gradle.model.ExtIdeaContentRoot;

public class JavaModuleContentRoot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final File myRootDirPath;
    private final Collection<File> mySourceDirPaths;
    private final Collection<File> myGenSourceDirPaths;
    private final Collection<File> myResourceDirPaths;
    private final Collection<File> myTestDirPaths;
    private final Collection<File> myGenTestDirPaths;
    private final Collection<File> myTestResourceDirPaths;
    private final Collection<File> myExcludeDirPaths;

    public static JavaModuleContentRoot copy(IdeaContentRoot original) {
        File rootDirPath = original.getRootDirectory();
        Collection<File> sourceDirPaths = JavaModuleContentRoot.copy((DomainObjectSet<? extends IdeaSourceDirectory>)original.getSourceDirectories());
        Collection<File> genSourceDirPaths = JavaModuleContentRoot.copy((DomainObjectSet<? extends IdeaSourceDirectory>)original.getGeneratedSourceDirectories());
        Collection<File> testDirPaths = JavaModuleContentRoot.copy((DomainObjectSet<? extends IdeaSourceDirectory>)original.getTestDirectories());
        Collection<File> genTestDirPaths = JavaModuleContentRoot.copy((DomainObjectSet<? extends IdeaSourceDirectory>)original.getGeneratedTestDirectories());
        Set<File> resourceDirPaths = Collections.emptySet();
        Set<File> testResourceDirPaths = Collections.emptySet();
        if (original instanceof ExtIdeaContentRoot) {
            ExtIdeaContentRoot extContentRoot = (ExtIdeaContentRoot)original;
            resourceDirPaths = JavaModuleContentRoot.copy((DomainObjectSet<? extends IdeaSourceDirectory>)extContentRoot.getResourceDirectories());
            testResourceDirPaths = JavaModuleContentRoot.copy((DomainObjectSet<? extends IdeaSourceDirectory>)extContentRoot.getTestResourceDirectories());
        }
        HashSet excludeDirPaths = Collections.emptySet();
        Set exclude = original.getExcludeDirectories();
        if (exclude != null) {
            excludeDirPaths = Sets.newHashSet();
            for (File path : exclude) {
                if (path == null) continue;
                excludeDirPaths.add(path);
            }
        }
        return new JavaModuleContentRoot(rootDirPath, sourceDirPaths, genSourceDirPaths, resourceDirPaths, testDirPaths, genTestDirPaths, testResourceDirPaths, excludeDirPaths);
    }

    private static Collection<File> copy(DomainObjectSet<? extends IdeaSourceDirectory> directories) {
        if (directories == null) {
            return Collections.emptySet();
        }
        HashSet paths = Sets.newHashSet();
        for (IdeaSourceDirectory directory : directories) {
            paths.add(directory.getDirectory());
        }
        return paths;
    }

    public JavaModuleContentRoot(File rootDirPath, Collection<File> sourceDirPaths, Collection<File> genSourceDirPaths, Collection<File> resourceDirPaths, Collection<File> testDirPaths, Collection<File> genTestDirPaths, Collection<File> testResourceDirPaths, Collection<File> excludeDirPaths) {
        this.myRootDirPath = rootDirPath;
        this.mySourceDirPaths = sourceDirPaths;
        this.myGenSourceDirPaths = genSourceDirPaths;
        this.myResourceDirPaths = resourceDirPaths;
        this.myTestDirPaths = testDirPaths;
        this.myGenTestDirPaths = genTestDirPaths;
        this.myTestResourceDirPaths = testResourceDirPaths;
        this.myExcludeDirPaths = excludeDirPaths;
    }

    public File getRootDirPath() {
        return this.myRootDirPath;
    }

    public Collection<File> getSourceDirPaths() {
        return this.mySourceDirPaths;
    }

    public Collection<File> getGenSourceDirPaths() {
        return this.myGenSourceDirPaths;
    }

    public Collection<File> getResourceDirPaths() {
        return this.myResourceDirPaths;
    }

    public Collection<File> getTestDirPaths() {
        return this.myTestDirPaths;
    }

    public Collection<File> getGenTestDirPaths() {
        return this.myGenTestDirPaths;
    }

    public Collection<File> getTestResourceDirPaths() {
        return this.myTestResourceDirPaths;
    }

    public Collection<File> getExcludeDirPaths() {
        return this.myExcludeDirPaths;
    }
}

