/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.messages;

import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;

public class Message {
    private final String myGroupName;
    private final Type myType;
    private final String[] myText;
    private final Navigatable myNavigatable;
    private final VirtualFile myFile;
    private final int myLine;
    private final int myColumn;

    public Message(String groupName, Type type, String ... text) {
        this(groupName, type, NonNavigatable.INSTANCE, text);
    }

    public Message(Project project, String groupName, Type type, VirtualFile file, int line, int column, String ... text) {
        this(groupName, type, (Navigatable)new OpenFileDescriptor(project, file, line, column), file, line, column, text);
    }

    public Message(String groupName, Type type, Navigatable navigatable, String ... text) {
        this(groupName, type, navigatable, null, -1, -1, text);
    }

    private Message(String groupName, Type type, Navigatable navigatable, VirtualFile file, int line, int column, String ... text) {
        this.myType = type;
        this.myText = text;
        this.myGroupName = groupName;
        this.myNavigatable = navigatable;
        this.myFile = file;
        this.myLine = line;
        this.myColumn = column;
    }

    public String getGroupName() {
        return this.myGroupName;
    }

    public Type getType() {
        return this.myType;
    }

    public String[] getText() {
        return this.myText;
    }

    public Navigatable getNavigatable() {
        return this.myNavigatable;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public int getLine() {
        return this.myLine;
    }

    public int getColumn() {
        return this.myColumn;
    }

    public static enum Type {
        ERROR(4),
        INFO(3),
        SIMPLE(1),
        WARNING(5);

        private final int myValue;

        private Type(int value) {
            this.myValue = value;
        }

        public int getValue() {
            return this.myValue;
        }

        public static Type find(String value) {
            for (Type type : Type.values()) {
                if (!type.name().equalsIgnoreCase(value)) continue;
                return type;
            }
            return null;
        }
    }
}

