/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.ui;

import com.android.tools.idea.gradle.editor.ui.GradleEditorUiConstants;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.Gray;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;

public class GradleEditorComboBoxEditor
implements ComboBoxEditor {
    public static final Border EDITOR_BORDER = new MacComboBoxEditorBorder(false);
    public static final Border DISABLED_EDITOR_BORDER = new MacComboBoxEditorBorder(true);
    private JTextField myField;
    private Object oldValue;

    public GradleEditorComboBoxEditor() {
        if (SystemInfo.isMac && UIUtil.isUnderAquaLookAndFeel()) {
            this.myField = new MacComboBoxTextField();
        } else {
            this.myField = new JTextField();
            this.myField.setBorder(null);
        }
    }

    protected JTextField getField() {
        return this.myField;
    }

    @Override
    public Component getEditorComponent() {
        return this.myField;
    }

    @Override
    public void setItem(Object anObject) {
        if (anObject != null) {
            this.myField.setText(anObject.toString());
            this.oldValue = anObject;
        } else {
            this.myField.setText("");
        }
    }

    @Override
    public Object getItem() {
        Object newValue = this.myField.getText();
        if (this.oldValue != null && !(this.oldValue instanceof String)) {
            if (newValue.equals(this.oldValue.toString())) {
                return this.oldValue;
            }
            Class<?> cls = this.oldValue.getClass();
            try {
                Method method = cls.getMethod("valueOf", String.class);
                newValue = method.invoke(this.oldValue, this.myField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return newValue;
    }

    @Override
    public void selectAll() {
        this.myField.selectAll();
        this.myField.requestFocus();
    }

    @Override
    public void addActionListener(ActionListener l) {
    }

    @Override
    public void removeActionListener(ActionListener l) {
    }

    private static ComboPopup getComboboxPopup(JComboBox comboBox) {
        ComboBoxUI ui = comboBox.getUI();
        ComboPopup popup = null;
        if (ui instanceof BasicComboBoxUI) {
            try {
                Field popupField = BasicComboBoxUI.class.getDeclaredField("popup");
                popupField.setAccessible(true);
                popup = (ComboPopup)popupField.get(ui);
            }
            catch (NoSuchFieldException e1) {
                popup = null;
            }
            catch (IllegalAccessException e1) {
                popup = null;
            }
        }
        return popup;
    }

    public static class MacComboBoxEditorBorder
    implements Border {
        private boolean myDisabled;

        public MacComboBoxEditorBorder(boolean disabled) {
            this.myDisabled = disabled;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Gray bottomColor;
            Gray leftRightColor;
            Gray secondTopColor;
            Gray topColor;
            if (this.myDisabled) {
                topColor = Gray._200;
                secondTopColor = Gray._250;
                leftRightColor = Gray._205;
                bottomColor = Gray._220;
            } else {
                topColor = Gray._150;
                secondTopColor = Gray._230;
                leftRightColor = Gray._175;
                bottomColor = Gray._200;
            }
            int _y = y + MacUIUtil.MAC_COMBO_BORDER_V_OFFSET;
            g.setColor((Color)topColor);
            g.drawLine(x + 3, _y + 3, x + width - 1, _y + 3);
            g.setColor((Color)secondTopColor);
            g.drawLine(x + 3, _y + 4, x + width - 1, _y + 4);
            g.setColor((Color)leftRightColor);
            g.drawLine(x + 3, _y + 4, x + 3, _y + height - 4);
            g.drawLine(x + width - 1, _y + 4, x + width - 1, _y + height - 4);
            g.setColor((Color)bottomColor);
            g.drawLine(x + 4, _y + height - 4, x + width - 2, _y + height - 4);
            g.setColor(GradleEditorUiConstants.BACKGROUND_COLOR);
            g.fillRect(x, y, width, 3 + (SystemInfo.isMacOSLion ? 1 : 0));
            g.fillRect(x, _y, 3, height);
            g.fillRect(x, _y + height - 3, width, 3);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(6, 6, 4, 3);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    private class MacComboBoxTextField
    extends JTextField
    implements DocumentListener,
    FocusListener {
        private MacComboBoxTextField() {
            this.setBorder(this.isEnabled() ? EDITOR_BORDER : DISABLED_EDITOR_BORDER);
            InputMap inputMap = this.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke("DOWN"), "aquaSelectNext");
            inputMap.put(KeyStroke.getKeyStroke("KP_DOWN"), "aquaSelectNext");
            inputMap.put(KeyStroke.getKeyStroke("UP"), "aquaSelectPrevious");
            inputMap.put(KeyStroke.getKeyStroke("KP_UP"), "aquaSelectPrevious");
            inputMap.put(KeyStroke.getKeyStroke("HOME"), "aquaSelectHome");
            inputMap.put(KeyStroke.getKeyStroke("END"), "aquaSelectEnd");
            inputMap.put(KeyStroke.getKeyStroke("PAGE_UP"), "aquaSelectPageUp");
            inputMap.put(KeyStroke.getKeyStroke("PAGE_DOWN"), "aquaSelectPageDown");
            inputMap.put(KeyStroke.getKeyStroke("ENTER"), "aquaEnterPressed");
            inputMap.put(KeyStroke.getKeyStroke("SPACE"), "aquaSpacePressed");
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("enabled".equals(evt.getPropertyName())) {
                        MacComboBoxTextField.this.setBorder(Boolean.TRUE.equals(evt.getNewValue()) ? EDITOR_BORDER : DISABLED_EDITOR_BORDER);
                        MacComboBoxTextField.this.repaint();
                    }
                }
            });
            this.addFocusListener(this);
        }

        @Override
        public boolean hasFocus() {
            Container parent = this.getParent();
            if (parent instanceof ComboBox) {
                try {
                    Field field = parent.getClass().getDeclaredField("myPaintingNow");
                    field.setAccessible(true);
                    if (field.get(parent) == Boolean.TRUE) {
                        return false;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return super.hasFocus();
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.repaintCombobox();
        }

        private void repaintCombobox() {
            Container parent = this.getParent();
            if (parent == null) {
                return;
            }
            if (parent instanceof JComponent && Boolean.TRUE == ((JComponent)parent).getClientProperty("JComboBox.isTableCellEditor")) {
                return;
            }
            Container grandParent = parent.getParent();
            if (grandParent != null) {
                grandParent.repaint();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.repaintCombobox();
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension minimumSize = super.getMinimumSize();
            return new Dimension(minimumSize.width, minimumSize.height + 2);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            UIUtil.setComboBoxEditorBounds((int)x, (int)y, (int)width, (int)height, (JComponent)this);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.textChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.textChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.textChanged();
        }

        private void textChanged() {
            Container ancestor = SwingUtilities.getAncestorOfClass(JComboBox.class, this);
            if (ancestor == null || !ancestor.isVisible()) {
                return;
            }
            JComboBox comboBox = (JComboBox)ancestor;
            if (!comboBox.isPopupVisible()) {
                return;
            }
            ComboPopup popup = GradleEditorComboBoxEditor.getComboboxPopup(comboBox);
            if (popup == null) {
                return;
            }
            String s = GradleEditorComboBoxEditor.this.myField.getText();
            ComboBoxModel listmodel = comboBox.getModel();
            int i = listmodel.getSize();
            if (s.length() > 0) {
                for (int j = 0; j < i; ++j) {
                    String s1;
                    Object obj = listmodel.getElementAt(j);
                    if (obj == null || (s1 = obj.toString()) == null || !s1.startsWith(s) && !s1.equals(s)) continue;
                    popup.getList().setSelectedIndex(j);
                    return;
                }
            }
            popup.getList().clearSelection();
        }
    }
}

