/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteralMap;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public final class GradleDslLiteral
extends GradleDslElement {
    private GrLiteral myLiteral;
    private Object myUnsavedValue;

    public GradleDslLiteral(GradleDslElement parent, String name) {
        super(parent, null, name);
    }

    public GradleDslLiteral(GradleDslElement parent, GroovyPsiElement psiElement, String name, GrLiteral literal) {
        super(parent, psiElement, name);
        this.myLiteral = literal;
    }

    GrLiteral getLiteral() {
        return this.myLiteral;
    }

    public Object getValue() {
        if (this.myUnsavedValue != null) {
            return this.myUnsavedValue;
        }
        if (this.myLiteral != null) {
            return this.myLiteral.getValue();
        }
        return null;
    }

    public <T> T getValue(Class<T> clazz) {
        Object value = this.getValue();
        if (value != null && clazz.isInstance(value)) {
            return clazz.cast(value);
        }
        return null;
    }

    public void setValue(Object value) {
        this.myUnsavedValue = value;
        this.setModified(true);
    }

    public String toString() {
        Object value = this.getValue();
        return value != null ? value.toString() : super.toString();
    }

    @Override
    protected Collection<GradleDslElement> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public GroovyPsiElement create() {
        GrNamedArgument addedNameArgument;
        GrLiteral literal;
        if (!(this.myParent instanceof GradleDslLiteralMap)) {
            return super.create();
        }
        GroovyPsiElement parentPsiElement = this.myParent.create();
        if (parentPsiElement == null) {
            return null;
        }
        this.setPsiElement(parentPsiElement);
        GrLiteral newLiteral = this.createLiteral();
        if (newLiteral == null) {
            return null;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)newLiteral.getProject());
        GrNamedArgument namedArgument = factory.createNamedArgument(this.myName, (GrExpression)newLiteral);
        PsiElement added = parentPsiElement.addAfter((PsiElement)namedArgument, parentPsiElement.getLastChild());
        if (added instanceof GrNamedArgument && (literal = (GrLiteral)PsiTreeUtil.getChildOfType((PsiElement)(addedNameArgument = (GrNamedArgument)added), GrLiteral.class)) != null) {
            this.myLiteral = literal;
            this.setModified(false);
            return this.getPsiElement();
        }
        return null;
    }

    @Override
    protected void delete() {
        if (this.myLiteral == null) {
            return;
        }
        PsiElement parent = this.myLiteral.getParent();
        this.myLiteral.delete();
        if (parent instanceof GrAssignmentExpression) {
            parent.delete();
        }
        if (parent instanceof GrCommandArgumentList) {
            GradleDslLiteral.deleteIfEmpty((GrCommandArgumentList)parent);
        } else if (parent instanceof GrListOrMap) {
            GradleDslLiteral.deleteIfEmpty((GrListOrMap)parent);
        }
    }

    private static void deleteIfEmpty(GrCommandArgumentList commandArgumentList) {
        if (commandArgumentList.getAllArguments().length > 0) {
            return;
        }
        PsiElement parent = commandArgumentList.getParent();
        commandArgumentList.delete();
        if (parent instanceof GrApplicationStatement) {
            parent.delete();
        }
    }

    private static void deleteIfEmpty(GrListOrMap listOrMap) {
        if (listOrMap.isMap() && listOrMap.getNamedArguments().length > 0 || !listOrMap.isMap() && listOrMap.getInitializers().length > 0) {
            return;
        }
        PsiElement parent = listOrMap.getParent();
        listOrMap.delete();
        if (parent instanceof GrAssignmentExpression) {
            parent.delete();
        }
    }

    @Override
    protected void apply() {
        GroovyPsiElement psiElement = this.getPsiElement();
        if (psiElement == null) {
            return;
        }
        GrLiteral newLiteral = this.createLiteral();
        if (newLiteral == null) {
            return;
        }
        if (this.myLiteral != null) {
            PsiElement replace = this.myLiteral.replace((PsiElement)newLiteral);
            if (replace instanceof GrLiteral) {
                this.myLiteral = (GrLiteral)replace;
            }
        } else {
            PsiElement added = psiElement.addAfter((PsiElement)newLiteral, psiElement.getLastChild());
            if (added instanceof GrLiteral) {
                this.myLiteral = (GrLiteral)added;
            }
        }
    }

    @Override
    protected void reset() {
        this.myUnsavedValue = null;
    }

    private GrLiteral createLiteral() {
        if (this.myUnsavedValue == null) {
            return null;
        }
        CharSequence unsavedValueText = null;
        if (this.myUnsavedValue instanceof String) {
            unsavedValueText = GrStringUtil.getLiteralTextByValue((String)((String)this.myUnsavedValue));
        } else if (this.myUnsavedValue instanceof Integer || this.myUnsavedValue instanceof Boolean) {
            unsavedValueText = this.myUnsavedValue.toString();
        }
        this.myUnsavedValue = null;
        if (unsavedValueText == null) {
            return null;
        }
        GroovyPsiElement psiElement = this.getPsiElement();
        if (psiElement == null) {
            return null;
        }
        Project project = psiElement.getProject();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
        GrExpression newExpression = factory.createExpressionFromText(unsavedValueText);
        if (!(newExpression instanceof GrLiteral)) {
            return null;
        }
        return (GrLiteral)newExpression;
    }
}

