/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.model.android.ProductFlavorModel;
import com.android.tools.idea.gradle.dsl.parser.android.AndroidDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.ProductFlavorDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.ProductFlavorsDslElement;
import java.util.Collection;
import java.util.List;

public final class AndroidModel {
    private static final String BUILD_TOOLS_VERSION = "buildToolsVersion";
    private static final String COMPILE_SDK_VERSION = "compileSdkVersion";
    private static final String DEFAULT_CONFIG = "defaultConfig";
    private static final String DEFAULT_PUBLISH_CONFIG = "defaultPublishConfig";
    private static final String FLAVOR_DIMENSIONS = "flavorDimensions";
    private static final String GENERATE_PURE_SPLITS = "generatePureSplits";
    private static final String PUBLISH_NON_DEFAULT = "publishNonDefault";
    private static final String RESOURCE_PREFIX = "resourcePrefix";
    private final AndroidDslElement myDslElement;

    public AndroidModel(AndroidDslElement dslElement) {
        this.myDslElement = dslElement;
    }

    public String buildToolsVersion() {
        Integer intValue = this.myDslElement.getProperty(BUILD_TOOLS_VERSION, Integer.class);
        return intValue != null ? intValue.toString() : this.myDslElement.getProperty(BUILD_TOOLS_VERSION, String.class);
    }

    public AndroidModel setBuildToolsVersion(int buildToolsVersion) {
        this.myDslElement.setLiteralProperty(BUILD_TOOLS_VERSION, buildToolsVersion);
        return this;
    }

    public AndroidModel setBuildToolsVersion(String buildToolsVersion) {
        this.myDslElement.setLiteralProperty(BUILD_TOOLS_VERSION, buildToolsVersion);
        return this;
    }

    public AndroidModel removeBuildToolsVersion() {
        this.myDslElement.removeProperty(BUILD_TOOLS_VERSION);
        return this;
    }

    public String compileSdkVersion() {
        Integer intValue = this.myDslElement.getProperty(COMPILE_SDK_VERSION, Integer.class);
        return intValue != null ? intValue.toString() : this.myDslElement.getProperty(COMPILE_SDK_VERSION, String.class);
    }

    public AndroidModel setCompileSdkVersion(int compileSdkVersion) {
        this.myDslElement.setLiteralProperty(COMPILE_SDK_VERSION, compileSdkVersion);
        return this;
    }

    public AndroidModel setCompileSdkVersion(String compileSdkVersion) {
        this.myDslElement.setLiteralProperty(COMPILE_SDK_VERSION, compileSdkVersion);
        return this;
    }

    public AndroidModel removeCompileSdkVersion() {
        this.myDslElement.removeProperty(COMPILE_SDK_VERSION);
        return this;
    }

    public ProductFlavorModel defaultConfig() {
        ProductFlavorDslElement parsedDefaultConfig = this.myDslElement.getProperty(DEFAULT_CONFIG, ProductFlavorDslElement.class);
        return parsedDefaultConfig != null ? new ProductFlavorModel(parsedDefaultConfig) : null;
    }

    public AndroidModel addDefaultConfig() {
        if (this.defaultConfig() != null) {
            return this;
        }
        ProductFlavorDslElement defaultConfig = new ProductFlavorDslElement(this.myDslElement, DEFAULT_CONFIG);
        this.myDslElement.setNewElement(DEFAULT_CONFIG, defaultConfig);
        return this;
    }

    public AndroidModel removeDefaultConfig() {
        this.myDslElement.removeProperty(DEFAULT_CONFIG);
        return this;
    }

    public String defaultPublishConfig() {
        return this.myDslElement.getProperty(DEFAULT_PUBLISH_CONFIG, String.class);
    }

    public AndroidModel setDefaultPublishConfig(String defaultPublishConfig) {
        this.myDslElement.setLiteralProperty(DEFAULT_PUBLISH_CONFIG, defaultPublishConfig);
        return this;
    }

    public AndroidModel removeDefaultPublishConfig() {
        this.myDslElement.removeProperty(DEFAULT_PUBLISH_CONFIG);
        return this;
    }

    public List<String> flavorDimensions() {
        return this.myDslElement.getListProperty(FLAVOR_DIMENSIONS, String.class);
    }

    public AndroidModel addFlavorDimension(String flavorDimension) {
        this.myDslElement.addToListProperty(FLAVOR_DIMENSIONS, flavorDimension);
        return this;
    }

    public AndroidModel removeFlavorDimension(String flavorDimension) {
        this.myDslElement.removeFromListProperty(FLAVOR_DIMENSIONS, flavorDimension);
        return this;
    }

    public AndroidModel removeAllFlavorDimensions() {
        this.myDslElement.removeProperty(FLAVOR_DIMENSIONS);
        return this;
    }

    public AndroidModel replaceFlavorDimension(String oldFlavorDimension, String newFlavorDimension) {
        this.myDslElement.replaceInListProperty(FLAVOR_DIMENSIONS, oldFlavorDimension, newFlavorDimension);
        return this;
    }

    public Boolean generatePureSplits() {
        return this.myDslElement.getProperty(GENERATE_PURE_SPLITS, Boolean.class);
    }

    public AndroidModel setGeneratePureSplits(boolean generatePureSplits) {
        this.myDslElement.setLiteralProperty(GENERATE_PURE_SPLITS, generatePureSplits);
        return this;
    }

    public AndroidModel removeGeneratePureSplits() {
        this.myDslElement.removeProperty(GENERATE_PURE_SPLITS);
        return this;
    }

    public Collection<ProductFlavorModel> productFlavors() {
        ProductFlavorsDslElement productFlavors = this.myDslElement.getProperty("productFlavors", ProductFlavorsDslElement.class);
        return productFlavors == null ? null : productFlavors.get();
    }

    public AndroidModel addProductFlavor(String flavor) {
        ProductFlavorDslElement flavorElement;
        ProductFlavorsDslElement productFlavors = this.myDslElement.getProperty("productFlavors", ProductFlavorsDslElement.class);
        if (productFlavors == null) {
            productFlavors = new ProductFlavorsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("productFlavors", productFlavors);
        }
        if ((flavorElement = productFlavors.getProperty(flavor, ProductFlavorDslElement.class)) == null) {
            flavorElement = new ProductFlavorDslElement(productFlavors, flavor);
            productFlavors.setNewElement(flavor, flavorElement);
        }
        return this;
    }

    public AndroidModel removeProductFlavor(String flavor) {
        ProductFlavorsDslElement productFlavors = this.myDslElement.getProperty("productFlavors", ProductFlavorsDslElement.class);
        if (productFlavors != null) {
            productFlavors.removeProperty(flavor);
        }
        return this;
    }

    public Boolean publishNonDefault() {
        return this.myDslElement.getProperty(PUBLISH_NON_DEFAULT, Boolean.class);
    }

    public AndroidModel setPublishNonDefault(boolean publishNonDefault) {
        this.myDslElement.setLiteralProperty(PUBLISH_NON_DEFAULT, publishNonDefault);
        return this;
    }

    public AndroidModel removePublishNonDefault() {
        this.myDslElement.removeProperty(PUBLISH_NON_DEFAULT);
        return this;
    }

    public String resourcePrefix() {
        return this.myDslElement.getProperty(RESOURCE_PREFIX, String.class);
    }

    public AndroidModel setResourcePrefix(String resourcePrefix) {
        this.myDslElement.setLiteralProperty(RESOURCE_PREFIX, resourcePrefix);
        return this;
    }

    public AndroidModel removeResourcePrefix() {
        this.myDslElement.removeProperty(RESOURCE_PREFIX);
        return this;
    }
}

