/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.dependencies.Dependencies;
import com.android.tools.idea.gradle.dsl.model.GradleFileModel;
import com.android.tools.idea.gradle.dsl.model.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.model.ext.ExtModel;
import com.android.tools.idea.gradle.dsl.model.java.JavaModel;
import com.android.tools.idea.gradle.dsl.parser.GradleDslElementParser;
import com.android.tools.idea.gradle.dsl.parser.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.GradleDslParser;
import com.android.tools.idea.gradle.dsl.parser.android.AndroidDslElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.java.JavaDslElement;
import com.android.tools.idea.gradle.dsl.parser.java.JavaProjectElementParser;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class GradleBuildModel
extends GradleFileModel {
    public static GradleBuildModel get(Module module) {
        VirtualFile file = GradleUtil.getGradleBuildFile(module);
        return file != null ? GradleBuildModel.parseBuildFile(file, module.getProject(), module.getName()) : null;
    }

    public static GradleBuildModel parseBuildFile(VirtualFile file, Project project, String moduleName) {
        GradleBuildDslFile buildDslFile = new GradleBuildDslFile(file, project, moduleName);
        buildDslFile.parse();
        return new GradleBuildModel(buildDslFile);
    }

    private GradleBuildModel(GradleBuildDslFile buildDslFile) {
        super(buildDslFile);
    }

    public AndroidModel android() {
        AndroidDslElement androidDslElement = this.myGradleDslFile.getProperty("android", AndroidDslElement.class);
        return androidDslElement != null ? new AndroidModel(androidDslElement) : null;
    }

    public GradleBuildModel addAndroidModel() {
        if (this.android() != null) {
            return this;
        }
        AndroidDslElement androidDslElement = new AndroidDslElement(this.myGradleDslFile);
        this.myGradleDslFile.setNewElement("android", androidDslElement);
        return this;
    }

    public GradleBuildModel removeAndroidModel() {
        this.myGradleDslFile.removeProperty("android");
        return this;
    }

    public Dependencies dependencies() {
        return ((GradleBuildDslFile)this.myGradleDslFile).myDependencies;
    }

    public ExtModel ext() {
        ExtDslElement extDslElement = this.myGradleDslFile.getProperty("ext", ExtDslElement.class);
        return extDslElement != null ? new ExtModel(extDslElement) : null;
    }

    public GradleBuildModel addExtModel() {
        if (this.ext() != null) {
            return this;
        }
        ExtDslElement extDslElement = new ExtDslElement(this.myGradleDslFile);
        this.myGradleDslFile.setNewElement("ext", extDslElement);
        return this;
    }

    public GradleBuildModel removeExtModel() {
        this.myGradleDslFile.removeProperty("ext");
        return this;
    }

    public JavaModel java() {
        JavaDslElement javaDslElement = this.myGradleDslFile.getProperty("java", JavaDslElement.class);
        return javaDslElement != null ? new JavaModel(javaDslElement) : null;
    }

    public GradleBuildModel addJavaModel() {
        if (this.java() != null) {
            return this;
        }
        JavaDslElement javaDslElement = new JavaDslElement(this.myGradleDslFile);
        this.myGradleDslFile.setNewElement("java", javaDslElement);
        return this;
    }

    public GradleBuildModel removeJavaModel() {
        this.myGradleDslFile.removeProperty("java");
        return this;
    }

    private static class GradleBuildDslFile
    extends GradleDslFile {
        private Dependencies myDependencies = new Dependencies(this);
        private final GradleDslElementParser[] myParsers = new GradleDslElementParser[]{new JavaProjectElementParser()};

        private GradleBuildDslFile(VirtualFile file, Project project, String moduleName) {
            super(file, project, moduleName);
        }

        @Override
        public void reparse() {
            this.myDependencies = new Dependencies(this);
            super.reparse();
        }

        @Override
        protected void parse(GroovyFile psiFile) {
            this.myDependencies.setPsiFile((PsiFile)psiFile);
            psiFile.acceptChildren((PsiElementVisitor)new GroovyPsiElementVisitor(new GroovyElementVisitor(){

                public void visitMethodCallExpression(GrMethodCallExpression e) {
                    if (GradleBuildDslFile.this.myDependencies.parse(e)) {
                        return;
                    }
                    this.process((GroovyPsiElement)e);
                }

                public void visitAssignmentExpression(GrAssignmentExpression e) {
                    this.process((GroovyPsiElement)e);
                }

                public void visitApplicationStatement(GrApplicationStatement e) {
                    this.process((GroovyPsiElement)e);
                }

                void process(GroovyPsiElement e) {
                    boolean parsed = false;
                    for (GradleDslElementParser parser : GradleBuildDslFile.this.myParsers) {
                        if (!parser.parse(e, GradleBuildDslFile.this)) continue;
                        parsed = true;
                        break;
                    }
                    if (!parsed) {
                        GradleDslParser.parse(e, GradleBuildDslFile.this);
                    }
                }
            }));
        }

        @Override
        protected void reset() {
            super.reset();
            this.myDependencies.resetState();
        }

        @Override
        protected void apply() {
            super.apply();
            this.myDependencies.applyChanges();
        }
    }
}

