/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.dependencies;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;

public class ExternalDependencySpec {
    public String name;
    public String group;
    public String version;
    public String classifier;
    public String extension;

    public ExternalDependencySpec(String name, String group, String version) {
        this(name, group, version, null, null);
    }

    public ExternalDependencySpec(String name, String group, String version, String classifier, String extension) {
        this.name = name;
        this.group = Strings.emptyToNull((String)group);
        this.version = Strings.emptyToNull((String)version);
        this.classifier = Strings.emptyToNull((String)classifier);
        this.extension = Strings.emptyToNull((String)extension);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalDependencySpec that = (ExternalDependencySpec)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.version, (Object)that.version) && Objects.equal((Object)this.classifier, (Object)that.classifier) && Objects.equal((Object)this.extension, (Object)that.extension);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.group, this.version, this.classifier, this.extension});
    }

    public String toString() {
        return this.compactNotation();
    }

    public String compactNotation() {
        ArrayList segments = Lists.newArrayList((Object[])new String[]{this.group, this.name, this.version, this.classifier});
        String s = Joiner.on((char)':').skipNulls().join((Iterable)segments);
        if (this.extension != null) {
            s = s + "@" + this.extension;
        }
        return s;
    }
}

