/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.dependencies;

import com.android.tools.idea.gradle.dsl.dependencies.Dependencies;
import com.android.tools.idea.gradle.dsl.dependencies.ModuleDependency;
import com.android.tools.idea.gradle.dsl.dependencies.external.ExternalDependency;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public abstract class Dependency
extends GradleDslElement {
    private final Dependencies myParent;
    private final GrMethodCall myMethodCall;
    private final String myConfigurationName;

    protected Dependency(Dependencies parent, GrMethodCall methodCall, String configurationName) {
        super(parent, null, configurationName);
        this.myParent = parent;
        this.myMethodCall = methodCall;
        this.myConfigurationName = configurationName;
    }

    public String configurationName() {
        return this.myConfigurationName;
    }

    protected Dependencies getParent() {
        return this.myParent;
    }

    protected GrMethodCall getMethodCall() {
        return this.myMethodCall;
    }

    protected void removeFromParent() {
        GrClosableBlock closureBlock = this.myParent.getClosureBlock();
        assert (closureBlock != null);
        closureBlock.removeElements(new PsiElement[]{this.myMethodCall});
    }

    static List<Dependency> parse(Dependencies parent, GrMethodCall methodCall) {
        if (methodCall instanceof GrMethodCallExpression) {
            return ExternalDependency.parse(parent, (GrMethodCallExpression)methodCall);
        }
        if (methodCall instanceof GrApplicationStatement) {
            return Dependency.parse(parent, (GrApplicationStatement)methodCall);
        }
        return Collections.emptyList();
    }

    private static List<Dependency> parse(Dependencies parent, GrApplicationStatement statement) {
        GrReferenceExpression configurationNameExpression = Dependency.findValidConfigurationNameExpression((GrMethodCall)statement);
        if (configurationNameExpression == null) {
            return Collections.emptyList();
        }
        GrCommandArgumentList argumentList = statement.getArgumentList();
        GroovyPsiElement[] arguments = argumentList.getAllArguments();
        List<Dependency> dependencies = ExternalDependency.parse(parent, (GrMethodCall)statement, configurationNameExpression, arguments);
        if (!dependencies.isEmpty()) {
            return dependencies;
        }
        int argumentCount = arguments.length;
        if (argumentCount == 0) {
            return Collections.emptyList();
        }
        GroovyPsiElement first = arguments[0];
        if (first instanceof GrMethodCallExpression) {
            Dependency dependency;
            GrMethodCallExpression expression = (GrMethodCallExpression)first;
            GrReferenceExpression referenceExpression = (GrReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)expression, GrReferenceExpression.class);
            if (referenceExpression == null) {
                return Collections.emptyList();
            }
            String referenceName = referenceExpression.getText();
            if ("project".equals(referenceName) && (dependency = Dependency.parseModuleDependency(parent, (GrMethodCall)statement, configurationNameExpression.getText(), (GrMethodCallExpression)first)) != null) {
                return Collections.singletonList(dependency);
            }
        }
        return Collections.emptyList();
    }

    protected static GrReferenceExpression findValidConfigurationNameExpression(GrMethodCall methodCall) {
        GrReferenceExpression found = (GrReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)methodCall, GrReferenceExpression.class);
        if (found != null && StringUtil.isNotEmpty((String)found.getText())) {
            return found;
        }
        return null;
    }

    private static Dependency parseModuleDependency(Dependencies parent, GrMethodCall methodCall, String configurationName, GrMethodCallExpression expression) {
        GrArgumentList argumentList = expression.getArgumentList();
        GroovyPsiElement[] arguments = argumentList.getAllArguments();
        if (arguments.length == 1 && arguments[0] instanceof GrLiteral) {
            GrLiteral literal = (GrLiteral)arguments[0];
            ModuleDependency moduleDependency = ModuleDependency.withCompactNotation(parent, methodCall, configurationName, literal);
            if (moduleDependency != null) {
                return moduleDependency;
            }
            return null;
        }
        ModuleDependency moduleDependency = ModuleDependency.withMapNotation(parent, methodCall, configurationName, argumentList);
        if (moduleDependency != null) {
            return moduleDependency;
        }
        return null;
    }
}

