/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.dependency;

import com.android.tools.idea.gradle.customizer.dependency.Dependency;
import com.android.tools.idea.gradle.customizer.dependency.LibraryDependency;
import com.android.tools.idea.gradle.customizer.dependency.ModuleDependency;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;

public class DependencySet {
    private final Multimap<String, LibraryDependency> myLibrariesByName = ArrayListMultimap.create();
    private final Map<String, ModuleDependency> myModulesByPath = Maps.newHashMap();

    void add(LibraryDependency dependency) {
        String originalName = dependency.getName();
        Collection allStored = this.myLibrariesByName.get((Object)originalName);
        if (allStored == null || allStored.isEmpty()) {
            this.myLibrariesByName.put((Object)originalName, (Object)dependency);
            return;
        }
        LibraryDependency toAdd = dependency;
        LibraryDependency replaced = null;
        for (LibraryDependency stored : allStored) {
            if (!DependencySet.areSameArtifact(dependency, stored)) continue;
            toAdd = null;
            if (!DependencySet.hasHigherScope(dependency, stored)) break;
            replaced = stored;
            dependency.setName(stored.getName());
            this.myLibrariesByName.put((Object)originalName, (Object)dependency);
            break;
        }
        if (replaced != null) {
            this.myLibrariesByName.remove((Object)originalName, replaced);
        }
        if (toAdd != null) {
            String newName = allStored.size() + "_" + dependency.getName();
            dependency.setName(newName);
            this.myLibrariesByName.put((Object)originalName, (Object)dependency);
        }
    }

    private static boolean areSameArtifact(LibraryDependency d1, LibraryDependency d2) {
        Collection<String> binaryPaths1 = d1.getPaths(LibraryDependency.PathType.BINARY);
        Collection<String> binaryPaths2 = d2.getPaths(LibraryDependency.PathType.BINARY);
        return ((Object)binaryPaths1).equals(binaryPaths2);
    }

    void add(ModuleDependency dependency) {
        String gradlePath = dependency.getGradlePath();
        Dependency storedDependency = this.myModulesByPath.get(gradlePath);
        if (storedDependency == null || DependencySet.hasHigherScope(dependency, storedDependency)) {
            this.myModulesByPath.put(gradlePath, dependency);
        }
    }

    private static <T extends Dependency> boolean hasHigherScope(T d1, T d2) {
        return Dependency.SUPPORTED_SCOPES.indexOf(d1.getScope()) < Dependency.SUPPORTED_SCOPES.indexOf(d2.getScope());
    }

    public Collection<LibraryDependency> onLibraries() {
        return this.myLibrariesByName.values();
    }

    public Collection<ModuleDependency> onModules() {
        return this.myModulesByPath.values();
    }
}

