/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.android;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.Variant;
import com.android.sdklib.repository.FullRevision;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.customizer.AbstractContentRootModuleCustomizer;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.variant.view.BuildVariantModuleCustomizer;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ContentRootModuleCustomizer
extends AbstractContentRootModuleCustomizer<AndroidGradleModel>
implements BuildVariantModuleCustomizer<AndroidGradleModel> {
    @Override
    protected Collection<ContentEntry> findOrCreateContentEntries(ModifiableRootModel moduleModel, AndroidGradleModel androidModel) {
        ArrayList contentEntries = Lists.newArrayList((Object[])new ContentEntry[]{moduleModel.addContentEntry(androidModel.getRootDir())});
        File buildFolderPath = androidModel.getAndroidProject().getBuildFolder();
        if (!FileUtil.isAncestor((File)androidModel.getRootDirPath(), (File)buildFolderPath, (boolean)false)) {
            contentEntries.add(moduleModel.addContentEntry(FilePaths.pathToIdeaUrl(buildFolderPath)));
        }
        return contentEntries;
    }

    @Override
    protected void setUpContentEntries(ModifiableRootModel moduleModel, Collection<ContentEntry> contentEntries, AndroidGradleModel androidModel, List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        Variant selectedVariant = androidModel.getSelectedVariant();
        AndroidArtifact mainArtifact = selectedVariant.getMainArtifact();
        this.addSourceFolders(androidModel, contentEntries, (BaseArtifact)mainArtifact, false, orphans);
        BaseArtifact testArtifact = androidModel.findSelectedTestArtifact(androidModel.getSelectedVariant());
        if (testArtifact != null) {
            this.addSourceFolders(androidModel, contentEntries, testArtifact, true, orphans);
        }
        for (String flavorName : selectedVariant.getProductFlavors()) {
            ProductFlavorContainer flavor = androidModel.findProductFlavor(flavorName);
            if (flavor == null) continue;
            this.addSourceFolder(androidModel, contentEntries, flavor, orphans);
        }
        String buildTypeName = selectedVariant.getBuildType();
        BuildTypeContainer buildTypeContainer = androidModel.findBuildType(buildTypeName);
        if (buildTypeContainer != null) {
            this.addSourceFolder(androidModel, contentEntries, buildTypeContainer.getSourceProvider(), false, orphans);
            Collection<SourceProvider> testSourceProviders = androidModel.getSourceProvidersForSelectedTestArtifact(buildTypeContainer.getExtraSourceProviders());
            for (SourceProvider testSourceProvider : testSourceProviders) {
                this.addSourceFolder(androidModel, contentEntries, testSourceProvider, true, orphans);
            }
        }
        ProductFlavorContainer defaultConfig = androidModel.getAndroidProject().getDefaultConfig();
        this.addSourceFolder(androidModel, contentEntries, defaultConfig, orphans);
        this.addExcludedOutputFolders(contentEntries, androidModel);
    }

    private void addSourceFolders(AndroidGradleModel androidModel, Collection<ContentEntry> contentEntries, BaseArtifact artifact, boolean isTest, List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        SourceProvider multiFlavorSourceProvider;
        this.addGeneratedSourceFolders(androidModel, contentEntries, artifact, isTest, orphans);
        SourceProvider variantSourceProvider = artifact.getVariantSourceProvider();
        if (variantSourceProvider != null) {
            this.addSourceFolder(androidModel, contentEntries, variantSourceProvider, isTest, orphans);
        }
        if ((multiFlavorSourceProvider = artifact.getMultiFlavorSourceProvider()) != null) {
            this.addSourceFolder(androidModel, contentEntries, multiFlavorSourceProvider, isTest, orphans);
        }
    }

    private void addGeneratedSourceFolders(AndroidGradleModel androidModel, Collection<ContentEntry> contentEntries, BaseArtifact artifact, boolean isTest, List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        Collection generatedSourceFolders;
        JpsModuleSourceRootType sourceType = ContentRootModuleCustomizer.getSourceType(isTest);
        if ((artifact instanceof AndroidArtifact || ContentRootModuleCustomizer.modelVersionIsAtLeast(androidModel, "1.2")) && (generatedSourceFolders = artifact.getGeneratedSourceFolders()) != null) {
            this.addSourceFolders(androidModel, contentEntries, generatedSourceFolders, sourceType, true, orphans);
        }
        if (artifact instanceof AndroidArtifact) {
            sourceType = ContentRootModuleCustomizer.getResourceSourceType(isTest);
            this.addSourceFolders(androidModel, contentEntries, ((AndroidArtifact)artifact).getGeneratedResourceFolders(), sourceType, true, orphans);
        }
    }

    private static boolean modelVersionIsAtLeast(AndroidGradleModel androidModel, String revision) {
        FullRevision modelVersion;
        String original = androidModel.getAndroidProject().getModelVersion();
        try {
            modelVersion = FullRevision.parseRevision((String)original);
        }
        catch (NumberFormatException e) {
            Logger.getInstance(AndroidGradleModel.class).warn("Failed to parse '" + original + "'", (Throwable)e);
            return false;
        }
        return modelVersion.compareTo(FullRevision.parseRevision((String)revision), FullRevision.PreviewComparison.IGNORE) >= 0;
    }

    private void addSourceFolder(AndroidGradleModel androidModel, Collection<ContentEntry> contentEntries, ProductFlavorContainer flavor, List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        this.addSourceFolder(androidModel, contentEntries, flavor.getSourceProvider(), false, orphans);
        Collection<SourceProvider> testSourceProviders = androidModel.getSourceProvidersForSelectedTestArtifact(flavor.getExtraSourceProviders());
        for (SourceProvider sourceProvider : testSourceProviders) {
            this.addSourceFolder(androidModel, contentEntries, sourceProvider, true, orphans);
        }
    }

    private void addSourceFolder(AndroidGradleModel androidModel, Collection<ContentEntry> contentEntries, SourceProvider sourceProvider, boolean isTest, List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        JpsModuleSourceRootType sourceType = ContentRootModuleCustomizer.getResourceSourceType(isTest);
        this.addSourceFolders(androidModel, contentEntries, sourceProvider.getResDirectories(), sourceType, false, orphans);
        this.addSourceFolders(androidModel, contentEntries, sourceProvider.getResourcesDirectories(), sourceType, false, orphans);
        this.addSourceFolders(androidModel, contentEntries, sourceProvider.getAssetsDirectories(), sourceType, false, orphans);
        sourceType = ContentRootModuleCustomizer.getSourceType(isTest);
        this.addSourceFolders(androidModel, contentEntries, sourceProvider.getAidlDirectories(), sourceType, false, orphans);
        this.addSourceFolders(androidModel, contentEntries, sourceProvider.getJavaDirectories(), sourceType, false, orphans);
        this.addSourceFolders(androidModel, contentEntries, sourceProvider.getCDirectories(), sourceType, false, orphans);
        this.addSourceFolders(androidModel, contentEntries, sourceProvider.getCppDirectories(), sourceType, false, orphans);
        this.addSourceFolders(androidModel, contentEntries, sourceProvider.getRenderscriptDirectories(), sourceType, false, orphans);
    }

    private static JpsModuleSourceRootType getResourceSourceType(boolean isTest) {
        return isTest ? JavaResourceRootType.TEST_RESOURCE : JavaResourceRootType.RESOURCE;
    }

    private static JpsModuleSourceRootType getSourceType(boolean isTest) {
        return isTest ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
    }

    private void addSourceFolders(AndroidGradleModel androidModel, Collection<ContentEntry> contentEntries, Collection<File> folderPaths, JpsModuleSourceRootType type, boolean generated, List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        for (File folderPath : folderPaths) {
            if (generated && !ContentRootModuleCustomizer.isGeneratedAtCorrectLocation(folderPath, androidModel.getAndroidProject())) {
                androidModel.registerExtraGeneratedSourceFolder(folderPath);
            }
            this.addSourceFolder(contentEntries, folderPath, type, generated, orphans);
        }
    }

    private static boolean isGeneratedAtCorrectLocation(File folderPath, AndroidProject project) {
        File generatedFolderPath = new File(project.getBuildFolder(), "generated");
        return FileUtil.isAncestor((File)generatedFolderPath, (File)folderPath, (boolean)false);
    }

    private void addExcludedOutputFolders(Collection<ContentEntry> contentEntries, AndroidGradleModel androidModel) {
        File buildFolderPath = androidModel.getAndroidProject().getBuildFolder();
        ContentEntry parentContentEntry = FilePaths.findParentContentEntry(buildFolderPath, contentEntries);
        if (parentContentEntry != null) {
            List<File> excludedFolderPaths = androidModel.getExcludedFolderPaths();
            for (File folderPath : excludedFolderPaths) {
                this.addExcludedFolder(parentContentEntry, folderPath);
            }
        }
    }

    @Override
    public ProjectSystemId getProjectSystemId() {
        return GradleUtil.GRADLE_SYSTEM_ID;
    }

    @Override
    public Class<AndroidGradleModel> getSupportedModelType() {
        return AndroidGradleModel.class;
    }
}

