/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer;

import com.android.tools.idea.gradle.customizer.ModuleCustomizer;
import com.android.tools.idea.gradle.util.FilePaths;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import java.io.File;

public abstract class AbstractCompileOutputModuleCustomizer<T>
implements ModuleCustomizer<T> {
    private static final Logger LOG = Logger.getInstance(AbstractCompileOutputModuleCustomizer.class);

    protected void setOutputPaths(ModifiableRootModel ideaModuleModel, File mainDirPath, File testDirPath) {
        CompilerModuleExtension compilerSettings = (CompilerModuleExtension)ideaModuleModel.getModuleExtension(CompilerModuleExtension.class);
        if (compilerSettings == null) {
            LOG.warn(String.format("No compiler extension is found for module '%1$s'", ideaModuleModel.getModule().getName()));
            return;
        }
        compilerSettings.inheritCompilerOutputPath(false);
        compilerSettings.setCompilerOutputPath(FilePaths.pathToIdeaUrl(mainDirPath));
        if (testDirPath != null) {
            compilerSettings.setCompilerOutputPathForTests(FilePaths.pathToIdeaUrl(testDirPath));
        }
    }
}

