/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.invoker.GradleInvoker;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.Lists;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.List;

public class GoToApkLocationTask
implements GradleInvoker.AfterGradleInvocationTask {
    private final Project myProject;
    private final String myNotificationTitle;
    private final List<File> myPotentialApkLocations;

    public GoToApkLocationTask(String notificationTitle, Module module, String apkPath) {
        AndroidGradleModel androidModel;
        this.myProject = module.getProject();
        this.myNotificationTitle = notificationTitle;
        this.myPotentialApkLocations = Lists.newArrayList();
        if (StringUtil.isNotEmpty((String)apkPath)) {
            this.myPotentialApkLocations.add(new File(apkPath));
        }
        if (Projects.isBuildWithGradle(this.myProject) && (androidModel = AndroidGradleModel.get(module)) != null) {
            File buildDirPath = androidModel.getAndroidProject().getBuildFolder();
            this.myPotentialApkLocations.add(new File(buildDirPath, FileUtil.join((String[])new String[]{"outputs", "apk"})));
            this.myPotentialApkLocations.add(buildDirPath);
        }
        File moduleFilePath = new File(FileUtil.toSystemDependentName((String)module.getModuleFilePath()));
        this.myPotentialApkLocations.add(moduleFilePath.getParentFile());
    }

    @Override
    public void execute(GradleInvocationResult result) {
        File apkPath = this.getExistingApkPath();
        AndroidGradleNotification notification = AndroidGradleNotification.getInstance(this.myProject);
        if (result.isBuildSuccessful()) {
            if (ShowFilePathAction.isSupported()) {
                notification.showBalloon(this.myNotificationTitle, "APK(s) generated successfully.", NotificationType.INFORMATION, new GoToPathHyperlink(apkPath));
                return;
            }
            String msg = String.format("APK(s) location is\n%1$s.", apkPath.getPath());
            notification.showBalloon(this.myNotificationTitle, msg, NotificationType.INFORMATION);
            return;
        }
        String msg = "Errors while building APK. You can find the errors in the 'Messages' view.";
        notification.showBalloon(this.myNotificationTitle, msg, NotificationType.ERROR);
    }

    private File getExistingApkPath() {
        for (File path : this.myPotentialApkLocations) {
            if (!path.isDirectory()) continue;
            return path;
        }
        String msg = String.format("None of the paths %1$s represent an existing directory", this.myPotentialApkLocations);
        throw new IllegalArgumentException(msg);
    }

    private static class GoToPathHyperlink
    extends NotificationHyperlink {
        private final File myDirPath;

        protected GoToPathHyperlink(File dirPath) {
            super("go.to.path", RevealFileAction.getActionName());
            this.myDirPath = dirPath;
        }

        @Override
        protected void execute(Project project) {
            ShowFilePathAction.openDirectory((File)this.myDirPath);
        }
    }
}

