/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.Lists;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CleanImportProjectAction
extends DumbAwareAction {
    private static final String MESSAGE_FORMAT = "This action will:\n1. Close project '%1$s'\n2. Delete all project files (.idea folder and .iml files)\n3. Import the project\n\nYou will lose custom project-wide settings. Are you sure you want to continue?";
    private static final String TITLE = "Close, Clean and Re-Import Project";
    private static final Logger LOG = Logger.getInstance(CleanImportProjectAction.class);

    public CleanImportProjectAction() {
        super(TITLE);
    }

    public void actionPerformed(AnActionEvent e) {
        String projectName;
        int answer;
        Project project = e.getProject();
        if (project != null && CleanImportProjectAction.isGradleProjectIfNotNull(project) && (answer = Messages.showYesNoDialog((Project)project, (String)String.format(MESSAGE_FORMAT, projectName = project.getName()), (String)TITLE, null)) == 0) {
            LOG.info(String.format("Closing, cleaning and re-importing project '%1$s'...", projectName));
            List<File> filesToDelete = CleanImportProjectAction.collectFilesToDelete(project);
            File projectDirPath = Projects.getBaseDirPath(project);
            CleanImportProjectAction.close(project);
            CleanImportProjectAction.deleteFiles(filesToDelete, projectName);
            try {
                LOG.info(String.format("About to import project '%1$s'.", projectName));
                GradleProjectImporter.getInstance().importNewlyCreatedProject(projectName, projectDirPath, null, null, null);
                LOG.info(String.format("Done importing project '%1$s'.", projectName));
            }
            catch (Exception error) {
                String title = CleanImportProjectAction.getErrorMessageTitle(error);
                Messages.showErrorDialog((String)error.getMessage(), (String)title);
                LOG.info(String.format("Failed to import project '%1$s'.", projectName));
            }
        }
    }

    private static List<File> collectFilesToDelete(Project project) {
        VirtualFile projectFile = project.getProjectFile();
        if (projectFile == null) {
            return Collections.emptyList();
        }
        ArrayList filesToDelete = Lists.newArrayList();
        filesToDelete.add(VfsUtilCore.virtualToIoFile((VirtualFile)projectFile.getParent()));
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            VirtualFile moduleFile = module.getModuleFile();
            if (moduleFile == null) continue;
            filesToDelete.add(VfsUtilCore.virtualToIoFile((VirtualFile)moduleFile));
        }
        return filesToDelete;
    }

    private static void close(Project project) {
        String projectName = project.getName();
        ProjectUtil.closeAndDispose((Project)project);
        RecentProjectsManager.getInstance().updateLastProjectPath();
        WelcomeFrame.showIfNoProjectOpened();
        LOG.info(String.format("Closed project '%1$s'.", projectName));
    }

    private static void deleteFiles(final List<File> files, String projectName) {
        Project project = ProjectManager.getInstance().getDefaultProject();
        String title = String.format("Cleaning up project '%1$s", projectName);
        ProgressManager.getInstance().run((Task)new Task.Modal(project, title, false){

            public void run(ProgressIndicator indicator) {
                indicator.setFraction(0.0);
                int fileCount = files.size();
                for (int i = 0; i < fileCount; ++i) {
                    File file = (File)files.get(i);
                    String path = file.getPath();
                    LOG.info(String.format("About to delete file '%1$s'", path));
                    if (!FileUtil.delete((File)file)) {
                        LOG.info(String.format("Failed to delete file '%1$s'", path));
                    }
                    indicator.setFraction((double)(i / fileCount));
                }
                indicator.setFraction(1.0);
            }
        });
    }

    private static String getErrorMessageTitle(Exception e) {
        if (e instanceof ConfigurationException) {
            return ((ConfigurationException)((Object)e)).getTitle();
        }
        return TITLE;
    }

    public void update(AnActionEvent e) {
        boolean isGradleProject = CleanImportProjectAction.isGradleProjectIfNotNull(e.getProject());
        Presentation presentation = e.getPresentation();
        presentation.setVisible(isGradleProject);
        presentation.setEnabled(isGradleProject);
    }

    private static boolean isGradleProjectIfNotNull(Project project) {
        return project != null && Projects.isBuildWithGradle(project);
    }
}

