/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.actions.AndroidStudioGradleAction;
import com.android.tools.idea.gradle.structure.editors.AndroidProjectSettingsService;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;

public abstract class AbstractProjectStructureAction
extends AndroidStudioGradleAction {
    public AbstractProjectStructureAction(String text) {
        super(text);
    }

    protected AbstractProjectStructureAction(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    @Override
    protected void doUpdate(AnActionEvent e, Project project) {
        e.getPresentation().setEnabled(this.getTargetModule(e) != null);
    }

    @Override
    protected final void doPerform(AnActionEvent e, Project project) {
        ProjectSettingsService service;
        Module module = this.getTargetModule(e);
        if (module != null && (service = ProjectSettingsService.getInstance((Project)module.getProject())) instanceof AndroidProjectSettingsService) {
            this.doPerform(module, (AndroidProjectSettingsService)service, e);
        }
    }

    protected abstract Module getTargetModule(AnActionEvent var1);

    protected static Module getSelectedAndroidModule(AnActionEvent e) {
        Module module = AbstractProjectStructureAction.getSelectedGradleModule(e);
        if (module != null && AndroidFacet.getInstance(module) != null) {
            return module;
        }
        return null;
    }

    protected static Module getSelectedGradleModule(AnActionEvent e) {
        ProjectFileIndex fileIndex;
        VirtualFile file;
        DataContext dataContext = e.getDataContext();
        Module module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        if (AbstractProjectStructureAction.isGradleModule(module)) {
            return module;
        }
        Project project = e.getProject();
        if (project != null && (file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext)) != null && AbstractProjectStructureAction.isGradleModule(module = (fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project)).getModuleForFile(file))) {
            return module;
        }
        return null;
    }

    private static boolean isGradleModule(Module module) {
        return module != null && Projects.isBuildWithGradle(module);
    }

    protected abstract void doPerform(Module var1, AndroidProjectSettingsService var2, AnActionEvent var3);
}

