/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.builder.model.AndroidProject;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.util.ProxyUtil;
import com.android.tools.idea.gradle.util.ui.ToolWindowAlikePanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;

public class InternalAndroidModelView {
    private final Project myProject;
    private final Tree myTree;

    public InternalAndroidModelView(Project project) {
        this.myProject = project;
        this.myTree = new Tree();
        GradleSyncState.subscribe(this.myProject, new GradleSyncListener.Adapter(){

            @Override
            public void syncStarted(Project project) {
                InternalAndroidModelView.this.updateContents();
            }

            @Override
            public void syncSucceeded(Project project) {
                InternalAndroidModelView.this.updateContents();
            }

            @Override
            public void syncFailed(Project project, String errorMessage) {
                InternalAndroidModelView.this.updateContents();
            }

            @Override
            public void syncSkipped(Project project) {
                InternalAndroidModelView.this.updateContents();
            }
        });
    }

    public static InternalAndroidModelView getInstance(Project project) {
        return (InternalAndroidModelView)ServiceManager.getService((Project)project, InternalAndroidModelView.class);
    }

    public void createToolWindowContent(ToolWindow toolWindow) {
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        ToolWindowAlikePanel toolWindowPanel = ToolWindowAlikePanel.createTreePanel(this.myProject.getName(), (JTree)this.myTree);
        Content content = contentFactory.createContent((JComponent)toolWindowPanel, "", false);
        toolWindow.getContentManager().addContent(content);
        this.updateContents();
    }

    private void updateContents() {
        this.myTree.setRootVisible(true);
        if (GradleSyncState.getInstance(this.myProject).isSyncInProgress()) {
            this.myTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode("Gradle project sync in progress ...")));
            return;
        }
        this.myTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode("Loading ...")));
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                final DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(InternalAndroidModelView.this.myProject.getName());
                for (Module module : ModuleManager.getInstance((Project)InternalAndroidModelView.this.myProject).getModules()) {
                    AndroidGradleModel androidModel = AndroidGradleModel.get(module);
                    if (androidModel == null) continue;
                    DefaultMutableTreeNode moduleNode = new DefaultMutableTreeNode(module.getName());
                    AndroidProject androidProject = androidModel.getProxyAndroidProject();
                    InternalAndroidModelView.this.addProxyObject(moduleNode, androidProject);
                    rootNode.add(moduleNode);
                }
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
                        renderer.setOpenIcon(AllIcons.Nodes.NewFolder);
                        renderer.setClosedIcon(AllIcons.Nodes.NewFolder);
                        renderer.setLeafIcon(AllIcons.ObjectBrowser.ShowModules);
                        InternalAndroidModelView.this.myTree.setCellRenderer((TreeCellRenderer)renderer);
                        DefaultTreeModel model = new DefaultTreeModel(rootNode);
                        InternalAndroidModelView.this.myTree.setRootVisible(false);
                        InternalAndroidModelView.this.myTree.setModel((TreeModel)model);
                    }
                });
            }
        });
    }

    void addProxyObject(DefaultMutableTreeNode node, Object obj) {
        this.addProxyObject(node, obj, false);
    }

    private void addProxyObject(DefaultMutableTreeNode node, Object obj, boolean useDerivedNodeName) {
        assert (ProxyUtil.isAndroidModelProxyObject(obj));
        String name = null;
        for (Map.Entry<String, Object> entry : ProxyUtil.getAndroidModelProxyValues(obj).entrySet()) {
            Object value;
            String property = entry.getKey();
            property = property.substring(0, property.lastIndexOf(40));
            if ((property = property.substring(property.lastIndexOf(46) + 1, property.length())).startsWith("get")) {
                property = property.substring(3);
            }
            if ((value = entry.getValue()) != null && property.equals("Name")) {
                name = value.toString();
            }
            this.addPropertyNode(node, property, value);
        }
        if (useDerivedNodeName && name != null) {
            node.setUserObject(name);
        }
    }

    private void addPropertyNode(DefaultMutableTreeNode node, String property, Object value) {
        DefaultMutableTreeNode propertyNode = new DefaultMutableTreeNode(property);
        if (value != null && ProxyUtil.isAndroidModelProxyObject(value)) {
            this.addProxyObject(propertyNode, value, property.isEmpty());
        } else if (value instanceof Collection && !((Collection)value).isEmpty()) {
            for (Object obj : (Collection)value) {
                this.addPropertyNode(propertyNode, "", obj);
            }
        } else if (value instanceof Map && !((Map)value).isEmpty()) {
            Map map = (Map)value;
            for (Object key : map.keySet()) {
                this.addPropertyNode(propertyNode, key.toString(), map.get(key));
            }
        } else if (value instanceof ProxyUtil.InvocationErrorValue) {
            Throwable exception = ((ProxyUtil.InvocationErrorValue)value).exception;
            propertyNode.setUserObject(InternalAndroidModelView.getNodeValue(property, "Error: " + exception.getClass().getName()));
        } else {
            propertyNode.setUserObject(InternalAndroidModelView.getNodeValue(property, this.getStringForValue(value)));
        }
        InternalAndroidModelView.addToNode(node, propertyNode);
    }

    private String getStringForValue(Object value) {
        if (value != null && value instanceof File) {
            String filePath = ((File)value).getPath();
            String basePath = this.myProject.getBasePath();
            if (basePath != null) {
                if (!basePath.endsWith(File.separator)) {
                    basePath = basePath + File.separator;
                }
                if (filePath.startsWith(basePath)) {
                    return filePath.substring(basePath.length());
                }
            }
        }
        return value == null ? "null" : value.toString();
    }

    private static String getNodeValue(String property, String value) {
        return property.isEmpty() ? value : property + " -> " + value;
    }

    private static void addToNode(DefaultMutableTreeNode parent, DefaultMutableTreeNode newChild) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            DefaultMutableTreeNode existingChild = (DefaultMutableTreeNode)parent.getChildAt(i);
            if (InternalAndroidModelView.compareTo(existingChild, newChild) < 0) continue;
            parent.insert(newChild, i);
            return;
        }
        parent.add(newChild);
    }

    private static int compareTo(DefaultMutableTreeNode node1, DefaultMutableTreeNode node2) {
        if (node1.isLeaf() && !node2.isLeaf()) {
            return -1;
        }
        if (!node1.isLeaf() && node2.isLeaf()) {
            return 1;
        }
        return node1.getUserObject().toString().compareTo(node2.getUserObject().toString());
    }
}

