/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.GradleTask;

public class GradleModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String myModuleName;
    private final List<String> myTaskNames;
    private final String myGradlePath;
    private final File myBuildFile;
    private final String myGradleVersion;

    public static GradleModel create(String moduleName, GradleProject gradleProject, File buildFile, String gradleVersion) {
        ArrayList taskNames = Lists.newArrayList();
        DomainObjectSet tasks = gradleProject.getTasks();
        if (!tasks.isEmpty()) {
            for (GradleTask task : tasks) {
                String name = task.getName();
                if (!StringUtil.isNotEmpty((String)name)) continue;
                taskNames.add(task.getProject().getPath() + ":" + task.getName());
            }
        }
        return new GradleModel(moduleName, taskNames, gradleProject.getPath(), buildFile, gradleVersion);
    }

    public GradleModel(String moduleName, List<String> taskNames, String gradlePath, File buildFile, String gradleVersion) {
        this.myModuleName = moduleName;
        this.myTaskNames = taskNames;
        this.myGradlePath = gradlePath;
        this.myBuildFile = buildFile;
        this.myGradleVersion = gradleVersion;
    }

    public String getModuleName() {
        return this.myModuleName;
    }

    public String getGradlePath() {
        return this.myGradlePath;
    }

    public List<String> getTaskNames() {
        return this.myTaskNames;
    }

    public VirtualFile getBuildFile() {
        return this.myBuildFile != null ? VfsUtil.findFileByIoFile((File)this.myBuildFile, (boolean)true) : null;
    }

    public String getGradleVersion() {
        return this.myGradleVersion;
    }
}

