/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.JavaCompileOptions;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.android.builder.model.SyncIssue;
import com.android.builder.model.Variant;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.FullRevision;
import com.android.tools.idea.gradle.AndroidProjectKeys;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.ProxyUtil;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class AndroidGradleModel
implements AndroidModel,
Serializable {
    public static final String EXPLODED_BUNDLES = "exploded-bundles";
    public static final String EXPLODED_AAR = "exploded-aar";
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getInstance(AndroidGradleModel.class);
    private ProjectSystemId myProjectSystemId;
    private String myModuleName;
    private File myRootDirPath;
    private AndroidProject myAndroidProject;
    private transient CountDownLatch myProxyAndroidProjectLatch;
    private AndroidProject myProxyAndroidProject;
    private String mySelectedVariantName;
    private transient VirtualFile myRootDir;
    private String mySelectedTestArtifactName;
    private Boolean myOverridesManifestPackage;
    private transient AndroidVersion myMinSdkVersion;
    private Map<String, BuildTypeContainer> myBuildTypesByName = Maps.newHashMap();
    private Map<String, ProductFlavorContainer> myProductFlavorsByName = Maps.newHashMap();
    private Map<String, Variant> myVariantsByName = Maps.newHashMap();
    private Set<File> myExtraGeneratedSourceFolders = Sets.newHashSet();
    private static final AndroidVersion NOT_SPECIFIED = new AndroidVersion(0, null);

    public AndroidGradleModel(ProjectSystemId projectSystemId, String moduleName, File rootDirPath, AndroidProject androidProject, String selectedVariantName, String selectedTestArtifactName) {
        this.myProjectSystemId = projectSystemId;
        this.myModuleName = moduleName;
        this.myRootDirPath = rootDirPath;
        this.myAndroidProject = androidProject;
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                AndroidGradleModel.this.myProxyAndroidProjectLatch = new CountDownLatch(1);
                AndroidGradleModel.this.myProxyAndroidProject = ProxyUtil.reproxy(AndroidProject.class, AndroidGradleModel.this.myAndroidProject);
                AndroidGradleModel.this.myProxyAndroidProjectLatch.countDown();
            }
        });
        this.populateBuildTypesByName();
        this.populateProductFlavorsByName();
        this.populateVariantsByName();
        this.setSelectedVariantName(selectedVariantName);
        this.setSelectedTestArtifactName(selectedTestArtifactName);
    }

    private void populateBuildTypesByName() {
        for (BuildTypeContainer container : this.myAndroidProject.getBuildTypes()) {
            String name = container.getBuildType().getName();
            this.myBuildTypesByName.put(name, container);
        }
    }

    private void populateProductFlavorsByName() {
        for (ProductFlavorContainer container : this.myAndroidProject.getProductFlavors()) {
            String name = container.getProductFlavor().getName();
            this.myProductFlavorsByName.put(name, container);
        }
    }

    private void populateVariantsByName() {
        for (Variant variant : this.myAndroidProject.getVariants()) {
            this.myVariantsByName.put(variant.getName(), variant);
        }
    }

    public AndroidArtifact getMainArtifact() {
        return this.getSelectedVariant().getMainArtifact();
    }

    @Override
    public SourceProvider getDefaultSourceProvider() {
        return this.getAndroidProject().getDefaultConfig().getSourceProvider();
    }

    @Override
    public List<SourceProvider> getActiveSourceProviders() {
        return this.getMainSourceProviders(this.mySelectedVariantName);
    }

    public List<SourceProvider> getMainSourceProviders(String variantName) {
        Variant variant = this.myVariantsByName.get(variantName);
        if (variant == null) {
            LOG.error("Unknown variant name '" + variantName + "' found in the module '" + this.myModuleName + "'");
            return ImmutableList.of();
        }
        ArrayList providers = Lists.newArrayList();
        providers.add(this.getDefaultSourceProvider());
        for (String flavor : variant.getProductFlavors()) {
            ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
            assert (productFlavor != null);
            providers.add(productFlavor.getSourceProvider());
        }
        AndroidArtifact mainArtifact = variant.getMainArtifact();
        SourceProvider multiFlavorProvider = mainArtifact.getMultiFlavorSourceProvider();
        if (multiFlavorProvider != null) {
            providers.add(multiFlavorProvider);
        }
        BuildTypeContainer buildType = this.findBuildType(variant.getBuildType());
        assert (buildType != null);
        providers.add(buildType.getSourceProvider());
        SourceProvider variantProvider = mainArtifact.getVariantSourceProvider();
        if (variantProvider != null) {
            providers.add(variantProvider);
        }
        return providers;
    }

    @Override
    public List<SourceProvider> getTestSourceProviders() {
        return this.getTestSourceProviders(this.mySelectedVariantName, this.mySelectedTestArtifactName);
    }

    public List<SourceProvider> getTestSourceProviders(String variantName, String testArtifactName) {
        if (!testArtifactName.equals("_android_test_") && !testArtifactName.equals("_unit_test_")) {
            LOG.error("Unknown artifact name '" + testArtifactName + "' found in the module '" + this.myModuleName + "'");
            return ImmutableList.of();
        }
        Variant variant = this.myVariantsByName.get(variantName);
        if (variant == null) {
            LOG.error("Unknown variant name '" + variantName + "' found in the module '" + this.myModuleName + "'");
            return ImmutableList.of();
        }
        ArrayList providers = Lists.newArrayList();
        Collection extraSourceProviders = this.getAndroidProject().getDefaultConfig().getExtraSourceProviders();
        providers.addAll(this.getSourceProvidersForTestArtifact(extraSourceProviders, testArtifactName));
        for (String flavor : variant.getProductFlavors()) {
            ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
            assert (productFlavor != null);
            providers.addAll(this.getSourceProvidersForTestArtifact(productFlavor.getExtraSourceProviders(), testArtifactName));
        }
        BuildTypeContainer buildType = this.findBuildType(variant.getBuildType());
        assert (buildType != null);
        providers.addAll(this.getSourceProvidersForTestArtifact(buildType.getExtraSourceProviders(), testArtifactName));
        return providers;
    }

    @Override
    public List<SourceProvider> getAllSourceProviders() {
        Collection variants = this.myAndroidProject.getVariants();
        ArrayList providers = Lists.newArrayList();
        providers.add(this.getDefaultSourceProvider());
        Collection flavors = this.myAndroidProject.getProductFlavors();
        for (ProductFlavorContainer pfc : flavors) {
            providers.add(pfc.getSourceProvider());
        }
        for (Variant v : variants) {
            SourceProvider provider = v.getMainArtifact().getMultiFlavorSourceProvider();
            if (provider == null) continue;
            providers.add(provider);
        }
        Collection buildTypes = this.myAndroidProject.getBuildTypes();
        for (BuildTypeContainer btc : buildTypes) {
            providers.add(btc.getSourceProvider());
        }
        for (Variant v : variants) {
            SourceProvider provider = v.getMainArtifact().getVariantSourceProvider();
            if (provider == null) continue;
            providers.add(provider);
        }
        return providers;
    }

    @Override
    public String getApplicationId() {
        return this.getSelectedVariant().getMainArtifact().getApplicationId();
    }

    @Override
    public Set<String> getAllApplicationIds() {
        HashSet ids = Sets.newHashSet();
        for (Variant v : this.myAndroidProject.getVariants()) {
            String applicationId = v.getMergedFlavor().getApplicationId();
            if (applicationId == null) continue;
            ids.add(applicationId);
        }
        return ids;
    }

    @Override
    public Boolean isDebuggable() {
        BuildTypeContainer buildTypeContainer = this.findBuildType(this.getSelectedVariant().getBuildType());
        if (buildTypeContainer != null) {
            return buildTypeContainer.getBuildType().isDebuggable();
        }
        return null;
    }

    @Override
    public AndroidVersion getMinSdkVersion() {
        if (this.myMinSdkVersion == null) {
            ApiVersion minSdkVersion = this.getSelectedVariant().getMergedFlavor().getMinSdkVersion();
            if (minSdkVersion != null && minSdkVersion.getCodename() != null) {
                ApiVersion defaultConfigVersion = this.getAndroidProject().getDefaultConfig().getProductFlavor().getMinSdkVersion();
                if (defaultConfigVersion != null) {
                    minSdkVersion = defaultConfigVersion;
                }
                List flavors = this.getSelectedVariant().getProductFlavors();
                for (String flavor : flavors) {
                    ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
                    assert (productFlavor != null);
                    ApiVersion flavorVersion = productFlavor.getProductFlavor().getMinSdkVersion();
                    if (flavorVersion == null) continue;
                    minSdkVersion = flavorVersion;
                    break;
                }
            }
            this.myMinSdkVersion = minSdkVersion != null ? LintUtils.convertVersion((ApiVersion)minSdkVersion, null) : NOT_SPECIFIED;
        }
        return this.myMinSdkVersion != NOT_SPECIFIED ? this.myMinSdkVersion : null;
    }

    @Override
    public AndroidVersion getRuntimeMinSdkVersion() {
        ApiVersion minSdkVersion = this.getSelectedVariant().getMergedFlavor().getMinSdkVersion();
        if (minSdkVersion != null) {
            return new AndroidVersion(minSdkVersion.getApiLevel(), minSdkVersion.getCodename());
        }
        return null;
    }

    @Override
    public AndroidVersion getTargetSdkVersion() {
        ApiVersion targetSdkVersion = this.getSelectedVariant().getMergedFlavor().getTargetSdkVersion();
        if (targetSdkVersion != null) {
            return new AndroidVersion(targetSdkVersion.getApiLevel(), targetSdkVersion.getCodename());
        }
        return null;
    }

    @Override
    public Integer getVersionCode() {
        Variant variant = this.getSelectedVariant();
        ProductFlavor flavor = variant.getMergedFlavor();
        return flavor.getVersionCode();
    }

    public ProjectSystemId getProjectSystemId() {
        return this.myProjectSystemId;
    }

    public BuildTypeContainer findBuildType(String name) {
        return this.myBuildTypesByName.get(name);
    }

    public Set<String> getBuildTypes() {
        return this.myBuildTypesByName.keySet();
    }

    public Set<String> getProductFlavors() {
        return this.myProductFlavorsByName.keySet();
    }

    public ProductFlavorContainer findProductFlavor(String name) {
        return this.myProductFlavorsByName.get(name);
    }

    public BaseArtifact findSelectedTestArtifact(Variant variant) {
        BaseArtifact artifact = this.getBaseArtifact(variant.getExtraAndroidArtifacts());
        if (artifact != null) {
            return artifact;
        }
        return this.getBaseArtifact(variant.getExtraJavaArtifacts());
    }

    private BaseArtifact getBaseArtifact(Iterable<? extends BaseArtifact> artifacts) {
        for (BaseArtifact baseArtifact : artifacts) {
            if (!this.getSelectedTestArtifactName().equals(baseArtifact.getName())) continue;
            return baseArtifact;
        }
        return null;
    }

    public BaseArtifact findSelectedTestArtifactInSelectedVariant() {
        return this.findSelectedTestArtifact(this.getSelectedVariant());
    }

    public String getModuleName() {
        return this.myModuleName;
    }

    @Override
    public File getRootDirPath() {
        return this.myRootDirPath;
    }

    @Override
    public VirtualFile getRootDir() {
        if (this.myRootDir == null) {
            VirtualFile found = VfsUtil.findFileByIoFile((File)this.myRootDirPath, (boolean)true);
            assert (found != null);
            this.myRootDir = found;
        }
        return this.myRootDir;
    }

    @Override
    public boolean isGenerated(VirtualFile file) {
        VirtualFile buildFolder = VfsUtil.findFileByIoFile((File)this.myAndroidProject.getBuildFolder(), (boolean)false);
        return buildFolder != null && VfsUtilCore.isAncestor((VirtualFile)buildFolder, (VirtualFile)file, (boolean)false);
    }

    public AndroidProject getAndroidProject() {
        return this.myAndroidProject;
    }

    AndroidProject getProxyAndroidProject() {
        this.waitForAndroidProjectProxy();
        assert (this.myProxyAndroidProject != null);
        return this.myProxyAndroidProject;
    }

    public Variant getSelectedVariant() {
        Variant selected = this.myVariantsByName.get(this.mySelectedVariantName);
        assert (selected != null);
        return selected;
    }

    public void setSelectedVariantName(String name) {
        String newVariantName;
        Collection<String> variantNames = this.getVariantNames();
        if (variantNames.contains(name)) {
            newVariantName = name;
        } else {
            ArrayList sorted = Lists.newArrayList(variantNames);
            Collections.sort(sorted);
            newVariantName = (String)sorted.get(0);
        }
        this.mySelectedVariantName = newVariantName;
        this.myOverridesManifestPackage = null;
        this.myMinSdkVersion = null;
    }

    public void setSelectedTestArtifactName(String selectedTestArtifactName) {
        assert (selectedTestArtifactName.equals("_android_test_") || selectedTestArtifactName.equals("_unit_test_"));
        this.mySelectedTestArtifactName = selectedTestArtifactName;
    }

    public String getSelectedTestArtifactName() {
        return this.mySelectedTestArtifactName;
    }

    public Collection<SourceProvider> getSourceProvidersForSelectedTestArtifact(Iterable<SourceProviderContainer> containers) {
        return this.getSourceProvidersForTestArtifact(containers, this.mySelectedTestArtifactName);
    }

    public Collection<SourceProvider> getSourceProvidersForTestArtifact(Iterable<SourceProviderContainer> containers, String testArtifactName) {
        HashSet providers = Sets.newHashSet();
        for (SourceProviderContainer container : containers) {
            if (!testArtifactName.equals(container.getArtifactName())) continue;
            providers.add(container.getSourceProvider());
        }
        return providers;
    }

    public Collection<String> getBuildTypeNames() {
        return this.myBuildTypesByName.keySet();
    }

    public Collection<String> getProductFlavorNames() {
        return this.myProductFlavorsByName.keySet();
    }

    public Collection<String> getVariantNames() {
        return this.myVariantsByName.keySet();
    }

    public LanguageLevel getJavaLanguageLevel() {
        JavaCompileOptions compileOptions = this.myAndroidProject.getJavaCompileOptions();
        String sourceCompatibility = compileOptions.getSourceCompatibility();
        return LanguageLevel.parse((String)sourceCompatibility);
    }

    public boolean isLibrary() {
        return this.getAndroidProject().isLibrary();
    }

    @Override
    public boolean overridesManifestPackage() {
        if (this.myOverridesManifestPackage == null) {
            this.myOverridesManifestPackage = this.getAndroidProject().getDefaultConfig().getProductFlavor().getApplicationId() != null;
            Variant variant = this.getSelectedVariant();
            List flavors = variant.getProductFlavors();
            for (String flavor : flavors) {
                ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
                assert (productFlavor != null);
                if (productFlavor.getProductFlavor().getApplicationId() == null) continue;
                this.myOverridesManifestPackage = true;
                break;
            }
        }
        return this.myOverridesManifestPackage;
    }

    public void registerExtraGeneratedSourceFolder(File folderPath) {
        this.myExtraGeneratedSourceFolders.add(folderPath);
    }

    public List<File> getExcludedFolderPaths() {
        File buildFolderPath = this.getAndroidProject().getBuildFolder();
        ArrayList excludedFolderPaths = Lists.newArrayList();
        if (buildFolderPath.isDirectory()) {
            for (File folderPath : FileUtil.notNullize((File[])buildFolderPath.listFiles())) {
                String folderName = folderPath.getName();
                if (folderName.equals("intermediates") || folderName.equals("generated")) continue;
                excludedFolderPaths.add(folderPath);
            }
            File intermediates = new File(buildFolderPath, "intermediates");
            if (intermediates.isDirectory()) {
                for (File folderPath : FileUtil.notNullize((File[])intermediates.listFiles())) {
                    String folderName = folderPath.getName();
                    if (folderName.equals(EXPLODED_AAR) || folderName.equals(EXPLODED_BUNDLES) || folderName.equals("manifest")) continue;
                    excludedFolderPaths.add(folderPath);
                }
            }
        } else {
            excludedFolderPaths.add(new File(buildFolderPath, "outputs"));
            excludedFolderPaths.add(new File(buildFolderPath, "tmp"));
        }
        return excludedFolderPaths;
    }

    public File[] getExtraGeneratedSourceFolders() {
        return this.myExtraGeneratedSourceFolders.toArray(new File[this.myExtraGeneratedSourceFolders.size()]);
    }

    public Collection<SyncIssue> getSyncIssues() {
        if (this.supportsIssueReporting()) {
            return this.myAndroidProject.getSyncIssues();
        }
        return null;
    }

    private boolean supportsIssueReporting() {
        FullRevision modelVersion;
        String original = this.myAndroidProject.getModelVersion();
        try {
            modelVersion = FullRevision.parseRevision((String)original);
        }
        catch (NumberFormatException e) {
            Logger.getInstance(AndroidGradleModel.class).warn("Failed to parse '" + original + "'", (Throwable)e);
            return false;
        }
        return modelVersion.compareTo(FullRevision.parseRevision((String)"1.1.0")) >= 0;
    }

    public SourceFileContainerInfo containsSourceFile(File file) {
        ProductFlavorContainer defaultConfig = this.myAndroidProject.getDefaultConfig();
        if (AndroidGradleModel.containsSourceFile(defaultConfig, file)) {
            return new SourceFileContainerInfo();
        }
        for (Variant variant : this.myAndroidProject.getVariants()) {
            AndroidArtifact artifact = variant.getMainArtifact();
            if (AndroidGradleModel.containsSourceFile((BaseArtifact)artifact, file)) {
                return new SourceFileContainerInfo(variant, (BaseArtifact)artifact);
            }
            for (AndroidArtifact extraArtifact : variant.getExtraAndroidArtifacts()) {
                if (!AndroidGradleModel.containsSourceFile((BaseArtifact)extraArtifact, file)) continue;
                return new SourceFileContainerInfo(variant, (BaseArtifact)extraArtifact);
            }
            String buildTypeName = variant.getBuildType();
            BuildTypeContainer buildTypeContainer = this.findBuildType(buildTypeName);
            if (buildTypeContainer != null) {
                if (AndroidGradleModel.containsFile(buildTypeContainer.getSourceProvider(), file)) {
                    return new SourceFileContainerInfo(variant);
                }
                for (SourceProviderContainer extraSourceProvider : buildTypeContainer.getExtraSourceProviders()) {
                    if (!AndroidGradleModel.containsFile(extraSourceProvider.getSourceProvider(), file)) continue;
                    return new SourceFileContainerInfo(variant);
                }
            }
            for (String flavorName : variant.getProductFlavors()) {
                ProductFlavorContainer flavor = this.findProductFlavor(flavorName);
                if (flavor == null || !AndroidGradleModel.containsSourceFile(flavor, file)) continue;
                return new SourceFileContainerInfo(variant);
            }
        }
        return null;
    }

    private static boolean containsSourceFile(ProductFlavorContainer flavorContainer, File file) {
        if (AndroidGradleModel.containsFile(flavorContainer.getSourceProvider(), file)) {
            return true;
        }
        for (SourceProviderContainer extraSourceProvider : flavorContainer.getExtraSourceProviders()) {
            if (!AndroidGradleModel.containsFile(extraSourceProvider.getSourceProvider(), file)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsSourceFile(BaseArtifact artifact, File file) {
        AndroidArtifact android;
        if (artifact instanceof AndroidArtifact && (AndroidGradleModel.containsFile((android = (AndroidArtifact)artifact).getGeneratedSourceFolders(), file) || AndroidGradleModel.containsFile(android.getGeneratedResourceFolders(), file))) {
            return true;
        }
        SourceProvider sourceProvider = artifact.getVariantSourceProvider();
        if (sourceProvider != null && AndroidGradleModel.containsFile(sourceProvider, file)) {
            return true;
        }
        sourceProvider = artifact.getMultiFlavorSourceProvider();
        return sourceProvider != null && AndroidGradleModel.containsFile(sourceProvider, file);
    }

    private static boolean containsFile(SourceProvider sourceProvider, File file) {
        return AndroidGradleModel.containsFile(sourceProvider.getAidlDirectories(), file) || AndroidGradleModel.containsFile(sourceProvider.getAssetsDirectories(), file) || AndroidGradleModel.containsFile(sourceProvider.getCDirectories(), file) || AndroidGradleModel.containsFile(sourceProvider.getCppDirectories(), file) || AndroidGradleModel.containsFile(sourceProvider.getJavaDirectories(), file) || AndroidGradleModel.containsFile(sourceProvider.getRenderscriptDirectories(), file) || AndroidGradleModel.containsFile(sourceProvider.getResDirectories(), file) || AndroidGradleModel.containsFile(sourceProvider.getResourcesDirectories(), file);
    }

    private static boolean containsFile(Collection<File> directories, File file) {
        for (File directory : directories) {
            if (!FileUtil.isAncestor((File)directory, (File)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private void waitForAndroidProjectProxy() {
        if (this.myProxyAndroidProjectLatch != null) {
            try {
                this.myProxyAndroidProjectLatch.await();
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.waitForAndroidProjectProxy();
        out.writeObject(this.myProjectSystemId);
        out.writeObject(this.myModuleName);
        out.writeObject(this.myRootDirPath);
        out.writeObject(this.myProxyAndroidProject);
        out.writeObject(this.mySelectedVariantName);
        out.writeObject(this.mySelectedTestArtifactName);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.myProjectSystemId = (ProjectSystemId)in.readObject();
        this.myModuleName = (String)in.readObject();
        this.myRootDirPath = (File)in.readObject();
        this.myProxyAndroidProject = this.myAndroidProject = (AndroidProject)in.readObject();
        this.myBuildTypesByName = Maps.newHashMap();
        this.myProductFlavorsByName = Maps.newHashMap();
        this.myVariantsByName = Maps.newHashMap();
        this.myExtraGeneratedSourceFolders = Sets.newHashSet();
        this.populateBuildTypesByName();
        this.populateProductFlavorsByName();
        this.populateVariantsByName();
        this.setSelectedVariantName((String)in.readObject());
        this.setSelectedTestArtifactName((String)in.readObject());
    }

    public static AndroidGradleModel get(Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        return facet != null ? AndroidGradleModel.get(facet) : null;
    }

    public static AndroidGradleModel get(AndroidFacet androidFacet) {
        AndroidModel androidModel = androidFacet.getAndroidModel();
        if (androidModel == null) {
            return null;
        }
        if (!(androidModel instanceof AndroidGradleModel)) {
            return null;
        }
        return (AndroidGradleModel)androidModel;
    }

    public SourceProvider getBuildTypeSourceProvider() {
        Variant selectedVariant = this.getSelectedVariant();
        BuildTypeContainer buildType = this.findBuildType(selectedVariant.getBuildType());
        assert (buildType != null);
        return buildType.getSourceProvider();
    }

    public List<SourceProvider> getFlavorSourceProviders() {
        Variant selectedVariant = this.getSelectedVariant();
        List productFlavors = selectedVariant.getProductFlavors();
        ArrayList providers = Lists.newArrayList();
        for (String flavor : productFlavors) {
            ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
            assert (productFlavor != null);
            providers.add(productFlavor.getSourceProvider());
        }
        return providers;
    }

    public void syncSelectedVariantAndTestArtifact(AndroidFacet facet) {
        Variant variant = this.getSelectedVariant();
        JpsAndroidModuleProperties state = facet.getProperties();
        state.SELECTED_BUILD_VARIANT = variant.getName();
        state.SELECTED_TEST_ARTIFACT = this.getSelectedTestArtifactName();
        AndroidArtifact mainArtifact = variant.getMainArtifact();
        BaseArtifact testArtifact = this.findSelectedTestArtifactInSelectedVariant();
        AndroidGradleModel.updateGradleTaskNames(state, mainArtifact, testArtifact);
    }

    static void updateGradleTaskNames(JpsAndroidModuleProperties state, AndroidArtifact mainArtifact, BaseArtifact testArtifact) {
        state.ASSEMBLE_TASK_NAME = mainArtifact.getAssembleTaskName();
        state.COMPILE_JAVA_TASK_NAME = mainArtifact.getCompileTaskName();
        state.AFTER_SYNC_TASK_NAMES = Sets.newHashSet(AndroidGradleModel.getIdeSetupTasks((BaseArtifact)mainArtifact));
        if (testArtifact != null) {
            state.ASSEMBLE_TEST_TASK_NAME = testArtifact.getAssembleTaskName();
            state.COMPILE_JAVA_TEST_TASK_NAME = testArtifact.getCompileTaskName();
            state.AFTER_SYNC_TASK_NAMES.addAll(AndroidGradleModel.getIdeSetupTasks(testArtifact));
        } else {
            state.ASSEMBLE_TEST_TASK_NAME = "";
            state.COMPILE_JAVA_TEST_TASK_NAME = "";
        }
    }

    private static Set<String> getIdeSetupTasks(BaseArtifact artifact) {
        block4: {
            try {
                return artifact.getIdeSetupTaskNames();
            }
            catch (NoSuchMethodError e) {
                if (artifact instanceof AndroidArtifact) {
                    return Sets.newHashSet((Object[])new String[]{((AndroidArtifact)artifact).getSourceGenTaskName()});
                }
            }
            catch (UnsupportedMethodException e) {
                if (!(artifact instanceof AndroidArtifact)) break block4;
                return Sets.newHashSet((Object[])new String[]{((AndroidArtifact)artifact).getSourceGenTaskName()});
            }
        }
        return Collections.emptySet();
    }

    public SourceProvider getMultiFlavorSourceProvider() {
        AndroidArtifact mainArtifact = this.getMainArtifact();
        return mainArtifact.getMultiFlavorSourceProvider();
    }

    public SourceProvider getVariantSourceProvider() {
        AndroidArtifact mainArtifact = this.getMainArtifact();
        return mainArtifact.getVariantSourceProvider();
    }

    @Override
    public boolean getDataBindingEnabled() {
        return GradleUtil.dependsOn(this, "com.android.databinding:library");
    }

    public static class SourceFileContainerInfo {
        public final Variant variant;
        public final BaseArtifact artifact;

        SourceFileContainerInfo() {
            this(null);
        }

        SourceFileContainerInfo(Variant variant) {
            this(variant, null);
        }

        SourceFileContainerInfo(Variant variant, BaseArtifact artifact) {
            this.variant = variant;
            this.artifact = artifact;
        }

        public void updateSelectedVariantIn(DataNode<ModuleData> moduleNode) {
            DataNode androidProjectNode;
            if (this.variant != null && (androidProjectNode = ExternalSystemApiUtil.find(moduleNode, AndroidProjectKeys.ANDROID_MODEL)) != null) {
                ((AndroidGradleModel)androidProjectNode.getData()).setSelectedVariantName(this.variant.getName());
            }
        }
    }
}

