/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.vmtrace;

import com.android.tools.idea.editors.vmtrace.TraceViewPanel;
import com.android.tools.perflib.vmtrace.VmTraceData;
import com.android.tools.perflib.vmtrace.VmTraceParser;
import com.google.common.base.Throwables;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JComponent;

public class VmTraceEditor
implements FileEditor {
    private final TraceViewPanel myTraceViewPanel;

    public VmTraceEditor(Project project, VirtualFile file) {
        this.myTraceViewPanel = new TraceViewPanel(project);
        this.parseTraceFileInBackground(project, file);
    }

    private void parseTraceFileInBackground(final Project project, final VirtualFile file) {
        final Task.Modal parseTask = new Task.Modal(project, "Parsing trace file", false){

            public void run(ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                File traceFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
                VmTraceParser parser = new VmTraceParser(traceFile);
                try {
                    parser.parse();
                }
                catch (Throwable throwable) {
                    ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            Messages.showErrorDialog((Project)project, (String)("Unexpected error while parsing trace file: " + Throwables.getRootCause((Throwable)throwable).getMessage()), (String)VmTraceEditor.this.getName());
                        }
                    }, ModalityState.defaultModalityState());
                    return;
                }
                final VmTraceData vmTraceData = parser.getTraceData();
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VmTraceEditor.this.myTraceViewPanel.setTrace(vmTraceData);
                    }
                });
            }
        };
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                parseTask.queue();
            }
        });
    }

    public JComponent getComponent() {
        return this.myTraceViewPanel.getComponent();
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    public String getName() {
        return "Traceview";
    }

    public FileEditorState getState(FileEditorStateLevel level) {
        return FileEditorState.INSTANCE;
    }

    public void setState(FileEditorState state) {
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }

    public <T> T getUserData(Key<T> key) {
        return null;
    }

    public <T> void putUserData(Key<T> key, T value) {
    }
}

