/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.ThemeSelectionDialog;
import com.android.tools.idea.configurations.ThemeSelectionPanel;
import com.android.tools.idea.editors.theme.ParentThemesListModel;
import com.android.tools.idea.editors.theme.ThemeEditorConstants;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.StyleListCellRenderer;
import com.android.tools.idea.editors.theme.attributes.editors.TypedCellRendererEditor;
import com.android.tools.idea.editors.theme.attributes.variants.VariantItemListener;
import com.android.tools.idea.editors.theme.attributes.variants.VariantsComboItem;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredElement;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.android.tools.idea.editors.theme.qualifiers.QualifierUtils;
import com.android.tools.idea.editors.theme.ui.VariantsComboBox;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColorUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.jetbrains.android.actions.CreateXmlResourceDialog;

public class ParentRendererEditor
extends TypedCellRendererEditor<ThemeEditorStyle, String> {
    private static final Logger LOG = Logger.getInstance(ParentRendererEditor.class);
    public static final String NO_PARENT = "[no parent]";
    private static final CollectionComboBoxModel NO_PARENT_MODEL = new CollectionComboBoxModel((List)ImmutableList.of((Object)"[no parent]"), (Object)"[no parent]");
    private final JComboBox myParentComboBox;
    private final VariantsComboBox myVariantsComboBox;
    private String myResultValue;
    private final ThemeEditorContext myContext;
    private final JPanel myPanel;
    private final ThemeParentChangedListener myThemeParentChangedListener;
    private ThemeEditorStyle myItem;
    private final JLabel myLabel;

    public ParentRendererEditor(ThemeEditorContext context, ThemeParentChangedListener themeParentChangedListener) {
        this.myContext = context;
        this.myThemeParentChangedListener = themeParentChangedListener;
        this.myParentComboBox = new JComboBox();
        this.myPanel = new JPanel(new BorderLayout(0, ThemeEditorConstants.ATTRIBUTE_ROW_GAP)){

            @Override
            public boolean isShowing() {
                return true;
            }
        };
        this.myPanel.setBorder(BorderFactory.createEmptyBorder(ThemeEditorConstants.ATTRIBUTE_MARGIN / 2, 0, ThemeEditorConstants.ATTRIBUTE_MARGIN / 2, 0));
        this.myVariantsComboBox = new VariantsComboBox();
        this.myVariantsComboBox.addItemListener(new VariantItemListener(context));
        this.myVariantsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ParentRendererEditor.this.stopCellEditing();
            }
        });
        this.myVariantsComboBox.addPopupClosingListener(new VariantsComboBox.PopupClosingListener(){

            @Override
            public void popupClosed() {
                ParentRendererEditor.this.stopCellEditing();
            }
        });
        this.myParentComboBox.setRenderer(new StyleListCellRenderer(context, this.myParentComboBox));
        this.myParentComboBox.addActionListener(new ParentChoiceListener());
        this.myParentComboBox.setMinimumSize(ThemeEditorConstants.ATTRIBUTES_PANEL_COMBO_MIN_SIZE);
        JPanel topLine = new JPanel(new BorderLayout());
        this.myLabel = new JLabel(String.format("<html><nobr><b><font color=\"#%1$s\">%2$s", ColorUtil.toHex((Color)ThemeEditorConstants.RESOURCE_ITEM_COLOR), "Theme parent"));
        topLine.add((Component)this.myLabel, "West");
        topLine.add((Component)this.myVariantsComboBox, "East");
        this.myPanel.add((Component)topLine, "First");
        this.myPanel.add((Component)this.myParentComboBox, "Center");
        this.myVariantsComboBox.addAction(new AbstractAction("Add variation"){

            @Override
            public boolean isEnabled() {
                return ParentRendererEditor.this.myItem != null && ParentRendererEditor.this.myItem.isProjectStyle();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ThemeEditorStyle sourceStyle = ParentRendererEditor.this.myItem;
                String themeName = sourceStyle.getName();
                Module module = ParentRendererEditor.this.myContext.getCurrentContextModule();
                CreateXmlResourceDialog resourceDialog = new CreateXmlResourceDialog(module, ResourceType.STYLE, themeName, " ", false);
                resourceDialog.setTitle(String.format("Create Theme '%1$s' Variant", themeName));
                if (!resourceDialog.showAndGet()) {
                    return;
                }
                String fileName = resourceDialog.getFileName();
                List<String> dirNames = resourceDialog.getDirNames();
                String resName = resourceDialog.getResourceName();
                String parentName = ParentRendererEditor.this.myItem.getParent().getQualifiedName();
                ThemeEditorUtils.createNewStyle(module, resName, parentName, fileName, dirNames);
            }
        });
    }

    private void updateVariantsCombo() {
        if (this.myItem == null) {
            this.myVariantsComboBox.setVisible(false);
            return;
        }
        this.myVariantsComboBox.setVisible(true);
        Collection allParents = this.myItem.getParentNames();
        String currentVariantColor = ColorUtil.toHex((Color)ThemeEditorConstants.CURRENT_VARIANT_COLOR);
        String notSelectedVariantColor = ColorUtil.toHex((Color)ThemeEditorConstants.NOT_SELECTED_VARIANT_COLOR);
        ArrayList variants = Lists.newArrayListWithCapacity((int)allParents.size());
        ThemeEditorStyle currentParent = this.myItem.getParent(this.myContext.getThemeResolver());
        ConfiguredElement selectedElement = null;
        if (currentParent != null) {
            selectedElement = (ConfiguredElement)currentParent.getConfiguration().getFullConfig().findMatchingConfigurable((List)ImmutableList.copyOf(allParents));
        }
        if (selectedElement == null) {
            selectedElement = allParents.iterator().next();
        }
        for (ConfiguredElement<String> configuredElement : allParents) {
            FolderConfiguration restrictedConfig = QualifierUtils.restrictConfiguration(configuredElement, allParents);
            String parentName = configuredElement.getElement();
            if (restrictedConfig == null) {
                LOG.warn(String.format("For style '%1$s': Folder configuration '%2$s' can never be selected. There are no qualifiers combination that would allow selecting it.", parentName, configuredElement.getConfiguration()));
                continue;
            }
            if (configuredElement.getConfiguration().equals((Object)selectedElement.getConfiguration())) {
                variants.add(0, new VariantsComboItem(String.format("<html><nobr><font color=\"#%1$s\">%2$s", currentVariantColor, configuredElement.getConfiguration().toShortDisplayString()), restrictedConfig, configuredElement.getConfiguration()));
                continue;
            }
            variants.add(new VariantsComboItem(String.format("<html><nobr><b><font color=\"#%1$s\">%2$s</font></b><font color=\"#9B9B9B\"> %3$s</font>", notSelectedVariantColor, configuredElement.getConfiguration().toShortDisplayString(), " - " + parentName), restrictedConfig, configuredElement.getConfiguration()));
        }
        this.myVariantsComboBox.setModel((ComboBoxModel)new CollectionComboBoxModel((List)variants, variants.get(0)));
    }

    @Override
    public Component getRendererComponent(JTable table, ThemeEditorStyle value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableModel model = table.getModel();
        ThemeEditorStyle parent = value.getParent();
        Font font = table.getFont();
        Font scaledFont = font.deriveFont((float)font.getSize() * 0.9f);
        this.myParentComboBox.setFont(scaledFont);
        this.myLabel.setFont(scaledFont);
        this.myParentComboBox.setEnabled(model.isCellEditable(row, column));
        if (parent == null) {
            this.myParentComboBox.setModel(NO_PARENT_MODEL);
            this.myItem = null;
        } else {
            ImmutableList<String> defaultThemeNames = ThemeEditorUtils.getDefaultThemeNames(this.myContext.getThemeResolver());
            this.myParentComboBox.setModel(new ParentThemesListModel((List<String>)defaultThemeNames, parent.getQualifiedName()));
            this.myItem = value;
        }
        this.updateVariantsCombo();
        return this.myPanel;
    }

    @Override
    public Component getEditorComponent(JTable table, ThemeEditorStyle value, boolean isSelected, int row, int column) {
        Font font = table.getFont();
        Font scaledFont = font.deriveFont((float)font.getSize() * 0.9f);
        this.myParentComboBox.setFont(scaledFont);
        this.myLabel.setFont(scaledFont);
        ThemeEditorStyle parent = value.getParent();
        ImmutableList<String> defaultThemeNames = ThemeEditorUtils.getDefaultThemeNames(this.myContext.getThemeResolver());
        this.myParentComboBox.setModel(new ParentThemesListModel((List<String>)defaultThemeNames, parent.getQualifiedName()));
        this.myResultValue = parent.getQualifiedName();
        this.myItem = value;
        this.updateVariantsCombo();
        return this.myPanel;
    }

    @Override
    public String getEditorValue() {
        return this.myResultValue;
    }

    private class ParentChoiceListener
    implements ActionListener {
        private ParentChoiceListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String selectedValue = (String)ParentRendererEditor.this.myParentComboBox.getSelectedItem();
            if ("Show all themes".equals(selectedValue)) {
                ParentRendererEditor.this.myParentComboBox.hidePopup();
                ThemeEditorStyle currentTheme = ParentRendererEditor.this.myContext.getCurrentTheme();
                assert (currentTheme != null);
                ThemeSelectionDialog dialog = new ThemeSelectionDialog(ParentRendererEditor.this.myContext.getConfiguration(), Collections.singleton(currentTheme.getQualifiedName()));
                dialog.setThemeChangedListener(ParentRendererEditor.this.myThemeParentChangedListener);
                dialog.show();
                ParentRendererEditor.this.myThemeParentChangedListener.reset();
                if (dialog.isOK()) {
                    String theme = dialog.getTheme();
                    ParentRendererEditor.this.myResultValue = theme == null ? null : theme;
                    ParentRendererEditor.this.stopCellEditing();
                } else {
                    ParentRendererEditor.this.myResultValue = null;
                    ParentRendererEditor.this.cancelCellEditing();
                }
            } else {
                ParentRendererEditor.this.myResultValue = selectedValue;
                ParentRendererEditor.this.stopCellEditing();
            }
        }
    }

    public static interface ThemeParentChangedListener
    extends ThemeSelectionPanel.ThemeChangedListener {
        public void reset();
    }
}

