/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ThemeEditorConstants;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.GraphicalResourceRendererEditor;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.preview.AndroidThemePreviewPanel;
import com.android.tools.idea.editors.theme.ui.ResourceComponent;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.swing.ui.SwatchComponent;
import com.google.common.collect.Iterables;
import com.intellij.openapi.module.Module;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;

public class DrawableRendererEditor
extends GraphicalResourceRendererEditor {
    private static final RenderLogger DRAWABLE_RENDER_LOGGER = new RenderLogger("ThemeEditorLogger", null);
    private static final int MIN_DRAWABLE_PREVIEW_SIZE = JBUI.scale((int)25);
    private final RenderTask myRenderTask;

    public DrawableRendererEditor(ThemeEditorContext context, AndroidThemePreviewPanel previewPanel, boolean isEditor) {
        super(context, previewPanel, isEditor);
        this.myRenderTask = DrawableRendererEditor.configureRenderTask(context.getCurrentContextModule(), context.getConfiguration());
    }

    public static RenderTask configureRenderTask(Module module, Configuration configuration) {
        RenderTask result = null;
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            RenderService service = RenderService.get(facet);
            result = service.createTask(null, configuration, DRAWABLE_RENDER_LOGGER, null);
        }
        return result;
    }

    @Override
    protected void updateComponent(ThemeEditorContext context, ResourceComponent component, EditedStyleItem item) {
        assert (context.getResourceResolver() != null);
        if (this.myRenderTask != null) {
            Dimension iconSize = component.getSwatchIconSize();
            int iconWidth = Math.max(iconSize.width, MIN_DRAWABLE_PREVIEW_SIZE);
            int iconHeight = Math.max(iconSize.height, MIN_DRAWABLE_PREVIEW_SIZE);
            this.myRenderTask.setMaxRenderSize(iconWidth, iconHeight);
            List<BufferedImage> images = this.myRenderTask.renderDrawableAllStates((ResourceValue)item.getSelectedValue());
            if (images.isEmpty()) {
                component.setSwatchIcon(SwatchComponent.WARNING_ICON);
            } else {
                component.setSwatchIcon(new SwatchComponent.SquareImageIcon((BufferedImage)Iterables.getLast(images)));
            }
            component.showStack(images.size() > 1);
        }
        String nameText = String.format("<html><nobr><b><font color=\"#%1$s\">%2$s", ColorUtil.toHex((Color)ThemeEditorConstants.RESOURCE_ITEM_COLOR), ThemeEditorUtils.getDisplayHtml(item));
        component.setNameText(nameText);
        component.setValueText(item.getValue());
    }

    @Override
    protected ResourceType[] getAllowedResourceTypes() {
        return GraphicalResourceRendererEditor.DRAWABLES_ONLY;
    }
}

