/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.TypedCellRendererEditor;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.intellij.openapi.project.Project;
import com.intellij.ui.TextFieldWithAutoCompletion;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class AttributeReferenceRendererEditor
extends TypedCellRendererEditor<EditedStyleItem, String> {
    protected final Box myBox = new Box(2);
    protected final JLabel myLabel = new JLabel(){

        @Override
        public boolean isShowing() {
            return true;
        }
    };
    protected final TextFieldWithAutoCompletion<String> myTextField;
    protected final CompletionProvider myCompletionProvider;
    protected EditedStyleItem myEditValue;
    protected String myStringValue;

    public AttributeReferenceRendererEditor(Project project, CompletionProvider completionProvider) {
        this.myCompletionProvider = project != null ? completionProvider : null;
        this.myTextField = new TextFieldWithAutoCompletion<String>(project, TextFieldWithAutoCompletion.EMPTY_COMPLETION, true, null){

            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (e.getKeyCode() == 10) {
                    AttributeReferenceRendererEditor.this.stopCellEditing();
                    return true;
                }
                return false;
            }
        };
        this.myBox.add((Component)this.myTextField);
        this.myBox.add(Box.createHorizontalGlue());
        this.myTextField.setAlignmentX(0.0f);
        this.myTextField.setOneLineMode(true);
        this.myLabel.setOpaque(true);
    }

    @Override
    public Component getRendererComponent(JTable table, EditedStyleItem value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component component;
        if (column == 0) {
            component = table.getDefaultRenderer(String.class).getTableCellRendererComponent(table, ThemeEditorUtils.getDisplayHtml(value), isSelected, hasFocus, row, column);
        } else {
            this.myLabel.setFont(table.getFont());
            this.myLabel.setText(value.getValue());
            this.myLabel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            component = this.myLabel;
        }
        return component;
    }

    @Override
    public Component getEditorComponent(JTable table, EditedStyleItem value, boolean isSelected, int row, int column) {
        this.myEditValue = value;
        this.myStringValue = value.getValue();
        this.myTextField.setText(this.myStringValue);
        this.myTextField.setFont(table.getFont());
        if (this.myCompletionProvider != null) {
            this.myTextField.setVariants(this.myCompletionProvider.getCompletions(value));
        }
        this.myBox.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        return this.myBox;
    }

    @Override
    public String getEditorValue() {
        return this.myTextField.getText();
    }

    public static interface CompletionProvider {
        public List<String> getCompletions(EditedStyleItem var1);
    }
}

