/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.tools.idea.editors.AndroidFakeFileSystem;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FakeFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.testFramework.LightVirtualFile;
import icons.AndroidIcons;
import javax.swing.Icon;

public class ThemeEditorVirtualFile
extends LightVirtualFile {
    public static final String FILENAME = "Theme Editor";
    private static final Key<ThemeEditorVirtualFile> KEY = Key.create((String)ThemeEditorVirtualFile.class.getName());
    private final Project myProject;

    private ThemeEditorVirtualFile(Project project) {
        super(FILENAME);
        this.myProject = project;
    }

    public static ThemeEditorVirtualFile getThemeEditorFile(Project project) {
        ThemeEditorVirtualFile vfile = (ThemeEditorVirtualFile)((Object)project.getUserData(KEY));
        if (vfile == null) {
            vfile = new ThemeEditorVirtualFile(project);
            project.putUserData(KEY, (Object)vfile);
        }
        return vfile;
    }

    public VirtualFile getParent() {
        return this.myProject.getBaseDir();
    }

    public FileType getFileType() {
        return ThemeEditorFileType.INSTANCE;
    }

    public Project getProject() {
        return this.myProject;
    }

    public VirtualFileSystem getFileSystem() {
        return AndroidFakeFileSystem.INSTANCE;
    }

    public String getPath() {
        return AndroidFakeFileSystem.constructPathForFile(FILENAME, this.myProject);
    }

    private static class ThemeEditorFileType
    extends FakeFileType {
        public static final ThemeEditorFileType INSTANCE = new ThemeEditorFileType();

        private ThemeEditorFileType() {
        }

        public boolean isMyFileType(VirtualFile file) {
            return file.getFileType() instanceof ThemeEditorFileType;
        }

        public String getName() {
            return "";
        }

        public String getDescription() {
            return "";
        }

        public Icon getIcon() {
            return AndroidIcons.Themes;
        }
    }
}

