/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.tools.swing.util.GraphicsUtil;
import com.google.common.collect.ImmutableList;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class ColorPalette
extends JComponent
implements Scrollable,
ItemSelectable {
    private int myColorBoxSize = JBUI.scale((int)50);
    private int myColorBoxPadding = this.myColorBoxSize / 10;
    private boolean myShowCheckeredBackground = false;
    private ColorPaletteModel myColorListModel;
    private final Border mySelectedBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
    private int mySelectedItem = -1;

    public ColorPalette(ColorPaletteModel colorListModel) {
        this.myColorListModel = colorListModel;
        this.setToolTipText("");
        this.setOpaque(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int selected = ColorPalette.this.itemAtPoint(e.getPoint());
                if (selected == ColorPalette.this.mySelectedItem) {
                    return;
                }
                if (ColorPalette.this.mySelectedItem != -1) {
                    ColorPalette.this.itemStateChanged(ColorPalette.this.mySelectedItem, 2);
                }
                if (selected != -1) {
                    ColorPalette.this.mySelectedItem = selected;
                    ColorPalette.this.itemStateChanged(ColorPalette.this.mySelectedItem, 1);
                    ColorPalette.this.repaint();
                } else {
                    ColorPalette.this.clearSelection();
                }
            }
        });
    }

    public ColorPalette() {
        this(new StaticColorPaletteModel(Collections.<Color>emptyList()));
    }

    public void setModel(ColorPaletteModel colorListModel) {
        this.myColorListModel = colorListModel;
        this.revalidate();
    }

    public ColorPaletteModel getModel() {
        return this.myColorListModel;
    }

    public void setColorBoxSize(int colorSize) {
        this.myColorBoxSize = colorSize;
        this.revalidate();
    }

    public void setColorBoxPadding(int padding) {
        this.myColorBoxPadding = padding;
        this.revalidate();
    }

    public void setShowCheckeredBackground(boolean showCheckeredBackground) {
        this.myShowCheckeredBackground = showCheckeredBackground;
    }

    @Override
    public Dimension getMinimumSize() {
        int minSize = this.myColorBoxSize + this.myColorBoxPadding * 2;
        return new Dimension(minSize, minSize);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet() || this.myColorListModel.getCount() < 1) {
            return super.getPreferredSize();
        }
        int minSize = this.myColorBoxSize + this.myColorBoxPadding * 2;
        return new Dimension(this.myColorListModel.getCount() * (this.myColorBoxSize + this.myColorBoxPadding) + this.myColorBoxPadding, minSize);
    }

    private int itemAtPoint(Point p) {
        if (p.y <= this.myColorBoxPadding || p.y > this.myColorBoxPadding + this.myColorBoxSize) {
            return -1;
        }
        if (p.x <= this.myColorBoxPadding) {
            return -1;
        }
        int position = (p.x - this.myColorBoxPadding) / (this.myColorBoxSize + this.myColorBoxPadding);
        int maxBoxX = position * (this.myColorBoxSize + this.myColorBoxPadding) + this.myColorBoxSize;
        if (p.x - this.myColorBoxPadding > maxBoxX) {
            return -1;
        }
        return position;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int position = this.itemAtPoint(event.getPoint());
        if (position == -1) {
            return "";
        }
        return this.myColorListModel.getToolTipAt(position);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myColorListModel.getCount() < 1) {
            return;
        }
        if (this.myShowCheckeredBackground) {
            GraphicsUtil.paintCheckeredBackground(g, new Rectangle(this.getSize()));
        }
        int width = this.getWidth();
        for (int i = 0; i < this.myColorListModel.getCount(); ++i) {
            g.setColor(this.myColorListModel.getColorAt(i));
            int x = i * (this.myColorBoxSize + this.myColorBoxPadding) + this.myColorBoxPadding;
            g.fillRect(x, this.myColorBoxPadding, this.myColorBoxSize, this.myColorBoxSize);
            if (this.mySelectedItem == i && this.mySelectedBorder != null) {
                g.setXORMode(Color.WHITE);
                this.mySelectedBorder.paintBorder(this, g, x, this.myColorBoxPadding, this.myColorBoxSize, this.myColorBoxSize);
                g.setPaintMode();
            }
            if (x > width) break;
        }
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.listenerList.getListeners(ItemListener.class);
    }

    @Override
    public Object[] getSelectedObjects() {
        if (this.mySelectedItem == -1) {
            return null;
        }
        return new Color[]{this.myColorListModel.getColorAt(this.mySelectedItem)};
    }

    @Override
    public void addItemListener(ItemListener l) {
        this.listenerList.add(ItemListener.class, l);
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.listenerList.remove(ItemListener.class, l);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension preferredSize = this.getPreferredSize();
        return new Dimension(preferredSize.width, preferredSize.height + UIUtil.getScrollBarWidth());
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 5;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.myColorBoxSize + this.myColorBoxPadding;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void clearSelection() {
        this.mySelectedItem = -1;
        this.repaint();
    }

    private void itemStateChanged(int position, int stateChange) {
        for (ItemListener itemListener : this.getItemListeners()) {
            itemListener.itemStateChanged(new ItemEvent(this, 701, this.myColorListModel.getColorAt(position), stateChange));
        }
    }

    public static class StaticColorPaletteModel
    implements ColorPaletteModel {
        private final List<Color> myColorList;

        public StaticColorPaletteModel(List<Color> colorList) {
            this.myColorList = ImmutableList.copyOf(colorList);
        }

        @Override
        public int getCount() {
            return this.myColorList.size();
        }

        @Override
        public Color getColorAt(int i) {
            return this.myColorList.get(i);
        }

        @Override
        public int indexOf(Color c) {
            return this.myColorList.indexOf(c);
        }

        @Override
        public String getToolTipAt(int i) {
            return this.myColorList.get(i).toString();
        }
    }

    public static interface ColorPaletteModel {
        public int getCount();

        public Color getColorAt(int var1);

        public int indexOf(Color var1);

        public String getToolTipAt(int var1);
    }
}

