/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;

final class XmlTagUtils {
    private static final Escaper ESCAPER = Escapers.builder().addEscape('\'', "\\'").build();

    private XmlTagUtils() {
    }

    static void escape(XmlTag tag) {
        for (XmlTagChild child : tag.getValue().getChildren()) {
            if (child instanceof XmlText) {
                XmlText text = (XmlText)child;
                if (text.getText().contains("<![CDATA[")) continue;
                text.setValue(ESCAPER.escape(text.getValue()));
                continue;
            }
            if (!(child instanceof XmlTag)) continue;
            XmlTagUtils.escape((XmlTag)child);
        }
    }

    static String unescape(XmlTag tag) {
        StringBuilder builder = new StringBuilder();
        XmlTagUtils.unescape(builder, tag);
        return builder.toString();
    }

    private static void unescape(StringBuilder builder, XmlTag tag) {
        for (XmlTagChild child : tag.getValue().getChildren()) {
            if (child instanceof XmlText) {
                String text = ((XmlText)child).getText();
                if (!text.contains("<![CDATA[")) {
                    text = text.replaceAll("\\\\'", "'");
                }
                builder.append(text);
                continue;
            }
            if (!(child instanceof XmlTag)) continue;
            XmlTag childTag = (XmlTag)child;
            String name = childTag.getName();
            builder.append('<');
            builder.append(name);
            XmlTagUtils.appendAttributes(builder, childTag);
            builder.append('>');
            XmlTagUtils.unescape(builder, childTag);
            builder.append("</");
            builder.append(name);
            builder.append('>');
        }
    }

    private static void appendAttributes(StringBuilder builder, XmlTag tag) {
        for (XmlAttribute attribute : tag.getAttributes()) {
            builder.append(' ');
            builder.append(attribute.getName());
            builder.append("=\"");
            builder.append(attribute.getValue());
            builder.append('\"');
        }
    }
}

