/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.strings.StringResourceEditor;
import com.android.tools.idea.editors.strings.StringsVirtualFile;
import com.android.tools.idea.rendering.ResourceHelper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;

public class StringResourceEditorProvider
implements FileEditorProvider,
DumbAware {
    public static final String ID = "string-resource-editor";

    public static boolean canViewTranslations(Project project, VirtualFile file) {
        if (!file.getName().equals(AndroidResourceUtil.getDefaultResourceFileName(ResourceType.STRING))) {
            return false;
        }
        if (ResourceHelper.getFolderType(file) != ResourceFolderType.VALUES) {
            return false;
        }
        Module m = ProjectFileIndex.SERVICE.getInstance((Project)project).getModuleForFile(file);
        return m != null && AndroidFacet.getInstance(m) != null;
    }

    public static void openEditor(final Module module) {
        StringsVirtualFile vf = StringsVirtualFile.getStringsVirtualFile(module);
        if (vf != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable((VirtualFile)vf){
                final /* synthetic */ VirtualFile val$vf;
                {
                    this.val$vf = virtualFile;
                }

                @Override
                public void run() {
                    Project project = module.getProject();
                    OpenFileDescriptor descriptor = new OpenFileDescriptor(project, this.val$vf);
                    FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
                }
            });
        }
    }

    public static void openEditor(final Project project, VirtualFile file) {
        StringsVirtualFile vf = StringsVirtualFile.getInstance(project, file);
        ApplicationManager.getApplication().invokeLater(new Runnable((VirtualFile)vf){
            final /* synthetic */ VirtualFile val$vf;
            {
                this.val$vf = virtualFile;
            }

            @Override
            public void run() {
                OpenFileDescriptor descriptor = new OpenFileDescriptor(project, this.val$vf);
                FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
            }
        });
    }

    public boolean accept(Project project, VirtualFile file) {
        return file instanceof StringsVirtualFile;
    }

    public FileEditor createEditor(Project project, VirtualFile file) {
        return new StringResourceEditor(project, file);
    }

    public void disposeEditor(FileEditor editor) {
        Disposer.dispose((Disposable)editor);
    }

    public FileEditorState readState(Element sourceElement, Project project, VirtualFile file) {
        return FileEditorState.INSTANCE;
    }

    public void writeState(FileEditorState state, Project project, Element targetElement) {
    }

    public String getEditorTypeId() {
        return ID;
    }

    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
    }
}

