/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.res2.ResourceItem;
import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.editors.strings.StringsWriteUtils;
import com.android.tools.idea.editors.strings.XmlTagUtils;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.rendering.PsiResourceItem;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;

public class StringResourceData {
    private final AndroidFacet myFacet;
    private final List<String> myKeys;
    private final Set<String> myUntranslatableKeys;
    private final List<Locale> myLocales;
    private final Map<String, ResourceItem> myDefaultValues;
    private final HashBasedTable<String, Locale, ResourceItem> myTranslations;

    public StringResourceData(AndroidFacet facet, List<String> keys, Collection<String> untranslatableKeys, Collection<Locale> locales, Map<String, ResourceItem> defaultValues, Table<String, Locale, ResourceItem> translations) {
        this.myFacet = facet;
        this.myKeys = Lists.newArrayList(keys);
        this.myUntranslatableKeys = Sets.newHashSet(untranslatableKeys);
        this.myLocales = Lists.newArrayList(locales);
        this.myDefaultValues = Maps.newHashMap(defaultValues);
        this.myTranslations = HashBasedTable.create(translations);
    }

    public List<String> getKeys() {
        return this.myKeys;
    }

    public Set<String> getUntranslatableKeys() {
        return this.myUntranslatableKeys;
    }

    public List<Locale> getLocales() {
        return this.myLocales;
    }

    public Map<String, ResourceItem> getDefaultValues() {
        return this.myDefaultValues;
    }

    public Table<String, Locale, ResourceItem> getTranslations() {
        return this.myTranslations;
    }

    public static String resourceToString(ResourceItem item) {
        XmlTag tag = ((PsiResourceItem)item).getTag();
        return tag == null ? "" : XmlTagUtils.unescape(tag).trim();
    }

    public static XmlTag resourceToXmlTag(ResourceItem item) {
        if (item instanceof PsiResourceItem) {
            XmlTag tag = ((PsiResourceItem)item).getTag();
            return tag != null && tag.isValid() ? tag : null;
        }
        return null;
    }

    public void changeKeyName(int index, String name) {
        if (index >= this.myKeys.size()) {
            throw new IllegalArgumentException(String.format("Cannot change key at index %1$d (# of entries: %2$d)", index, this.myKeys.size()));
        }
        if (this.myKeys.contains(name)) {
            throw new IllegalArgumentException("Key " + name + " already exists.");
        }
        String currentName = this.myKeys.get(index);
        ResourceItem defaultValue = this.myDefaultValues.get(currentName);
        Map translations = this.myTranslations.row((Object)currentName);
        this.myKeys.remove(index);
        this.myKeys.add(name);
        Collections.sort(this.myKeys);
        if (defaultValue != null) {
            this.myDefaultValues.remove(currentName);
            this.myDefaultValues.put(name, defaultValue);
        }
        if (!translations.isEmpty()) {
            this.myTranslations.row((Object)name).putAll(translations);
            translations.clear();
        }
    }

    public boolean setDoNotTranslate(String key, boolean doNotTranslate) {
        ResourceItem item = this.myDefaultValues.get(key);
        if (item != null) {
            String translatable;
            if (doNotTranslate) {
                translatable = "false";
                this.myUntranslatableKeys.add(key);
            } else {
                translatable = null;
                this.myUntranslatableKeys.remove(key);
            }
            return StringsWriteUtils.setAttributeForItems(this.myFacet.getModule().getProject(), "translatable", translatable, Collections.singletonList(item));
        }
        return false;
    }

    public boolean setTranslation(String key, Locale locale, String value) {
        ResourceItem currentItem;
        ResourceItem resourceItem = currentItem = locale == null ? this.myDefaultValues.get(key) : (ResourceItem)this.myTranslations.get((Object)key, (Object)locale);
        if (currentItem != null) {
            String oldText = StringResourceData.resourceToString(currentItem);
            if (!StringUtil.equals((CharSequence)oldText, (CharSequence)value)) {
                boolean changed = StringsWriteUtils.setItemText(this.myFacet.getModule().getProject(), currentItem, value);
                if (changed && value.isEmpty()) {
                    if (locale == null) {
                        this.myDefaultValues.remove(key);
                    } else {
                        this.myTranslations.remove((Object)key, (Object)locale);
                    }
                }
                return changed;
            }
        } else {
            VirtualFile primaryResourceDir = this.myFacet.getPrimaryResourceDir();
            assert (primaryResourceDir != null);
            ResourceItem item = StringsWriteUtils.createItem(this.myFacet, primaryResourceDir, locale, key, value, !this.getUntranslatableKeys().contains(key));
            if (item != null) {
                if (locale == null) {
                    this.myDefaultValues.put(key, item);
                } else {
                    this.myTranslations.put((Object)key, (Object)locale, (Object)item);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public String validateKey(String key) {
        if (!this.myKeys.contains(key)) {
            throw new IllegalArgumentException("Key " + key + " does not exist.");
        }
        Map translationsForKey = this.myTranslations.row((Object)key);
        if (this.myUntranslatableKeys.contains(key)) {
            if (!translationsForKey.isEmpty()) {
                Set<Locale> localesWithTranslation = translationsForKey.keySet();
                return String.format("Key '%1$s' is marked as non translatable, but is translated in %2$s %3$s", key, StringUtil.pluralize((String)"locale", (int)localesWithTranslation.size()), StringResourceData.summarizeLocales(localesWithTranslation));
            }
        } else {
            if (this.myDefaultValues.get(key) == null) {
                return "Key '" + key + "' missing default value";
            }
            Collection<Locale> missingTranslations = this.getMissingTranslations(key);
            if (!missingTranslations.isEmpty()) {
                return String.format("Key '%1$s' has translations missing for %2$s %3$s", key, StringUtil.pluralize((String)"locale", (int)missingTranslations.size()), StringResourceData.summarizeLocales(missingTranslations));
            }
        }
        return null;
    }

    public String validateTranslation(String key, Locale locale) {
        if (!this.myKeys.contains(key)) {
            throw new IllegalArgumentException("Key " + key + " does not exist.");
        }
        if (locale == null) {
            ResourceItem item = this.myDefaultValues.get(key);
            return item == null ? String.format("Key '%1$s' is missing the default value", key) : null;
        }
        boolean translationMissing = this.isTranslationMissing(key, locale);
        boolean doNotTranslate = this.myUntranslatableKeys.contains(key);
        if (translationMissing && !doNotTranslate) {
            return String.format("Key '%1$s' is missing %2$s translation", key, StringResourceData.getLabel(locale));
        }
        if (doNotTranslate && !translationMissing) {
            return String.format("Key '%1$s' is marked as non-localizable, and should not be translated to %2$s", key, StringResourceData.getLabel(locale));
        }
        return null;
    }

    @VisibleForTesting
    Collection<Locale> getMissingTranslations(String key) {
        HashSet missingTranslations = Sets.newHashSet();
        for (Locale locale : this.myLocales) {
            if (!this.isTranslationMissing(key, locale)) continue;
            missingTranslations.add(locale);
        }
        return missingTranslations;
    }

    @VisibleForTesting
    boolean isTranslationMissing(String key, Locale locale) {
        ResourceItem item = (ResourceItem)this.myTranslations.get((Object)key, (Object)locale);
        if (StringResourceData.isTranslationMissing(item) && locale.hasRegion()) {
            locale = Locale.create(locale.qualifier.getLanguage());
            item = (ResourceItem)this.myTranslations.get((Object)key, (Object)locale);
        }
        return StringResourceData.isTranslationMissing(item);
    }

    private static boolean isTranslationMissing(ResourceItem item) {
        return item == null || StringResourceData.resourceToString(item).isEmpty();
    }

    @VisibleForTesting
    static String summarizeLocales(Collection<Locale> locales) {
        if (locales.isEmpty()) {
            return "";
        }
        int size = locales.size();
        if (size == 1) {
            return StringResourceData.getLabel((Locale)Iterables.getFirst(locales, null));
        }
        int max = 3;
        List<Locale> sorted = StringResourceData.getLowest(locales, 3);
        if (size <= 3) {
            return String.format("%1$s and %2$s", StringResourceData.getLabels(Iterables.limit(sorted, (int)(size - 1))), StringResourceData.getLabel(sorted.get(size - 1)));
        }
        return String.format("%1$s and %2$d more", StringResourceData.getLabels(sorted), size - 3);
    }

    private static List<Locale> getLowest(Collection<Locale> locales, int n) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)n);
        ArrayList input = Lists.newArrayList(locales);
        Comparator<Locale> comparator = new Comparator<Locale>(){

            @Override
            public int compare(Locale l1, Locale l2) {
                return StringResourceData.getLabel(l1).compareTo(StringResourceData.getLabel(l2));
            }
        };
        for (int i = 0; i < locales.size() && i < n; ++i) {
            Locale min = Collections.min(input, comparator);
            result.add(min);
            input.remove(min);
        }
        return result;
    }

    private static String getLabels(Iterable<Locale> locales) {
        return Joiner.on((String)", ").join(Iterables.transform(locales, (Function)new Function<Locale, String>(){

            public String apply(Locale locale) {
                return StringResourceData.getLabel(locale);
            }
        }));
    }

    private static String getLabel(Locale locale) {
        return locale == null ? "" : LocaleMenuAction.getLocaleLabel(locale, false);
    }
}

