/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.ResourceNameValidator;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jdesktop.swingx.combobox.ListComboBoxModel;
import org.jetbrains.android.facet.AndroidFacet;

public class NewStringKeyDialog
extends DialogWrapper {
    private JPanel myPanel;
    private JComboBox myResFolderCombo;
    private EditorTextField myKeyField;
    private EditorTextField myDefaultValueField;
    private String myKey;
    private String myDefaultValue;
    private VirtualFile myResFolder;
    private final ResourceNameValidator myResourceNameValidator;

    public NewStringKeyDialog(AndroidFacet facet, Set<String> existing) {
        super(facet.getModule().getProject(), false);
        this.$$$setupUI$$$();
        final VirtualFile baseDir = facet.getModule().getProject().getBaseDir();
        this.myResFolderCombo.setModel(new ListComboBoxModel(facet.getAllResourceDirectories()));
        this.myResFolderCombo.setRenderer(new ListCellRendererWrapper<VirtualFile>(){

            public void customize(JList list, VirtualFile file, int index, boolean selected, boolean hasFocus) {
                this.setText(VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)baseDir, (char)File.separatorChar));
            }
        });
        this.myResFolderCombo.setSelectedIndex(0);
        this.myResourceNameValidator = ResourceNameValidator.create(false, existing, ResourceType.STRING);
        this.init();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myKeyField;
    }

    protected ValidationInfo doValidate() {
        if (this.myKeyField.getText().isEmpty()) {
            return new ValidationInfo("Key cannot be empty", (JComponent)this.myKeyField);
        }
        String key = this.myKeyField.getText().trim();
        String error = this.myResourceNameValidator.getErrorText(key);
        if (error != null) {
            return new ValidationInfo(error, (JComponent)this.myKeyField);
        }
        if (this.myDefaultValueField.getText().isEmpty()) {
            return new ValidationInfo("Default Value cannot be empty", (JComponent)this.myDefaultValueField);
        }
        return null;
    }

    protected void doOKAction() {
        this.myKey = this.myKeyField.getText().trim();
        this.myDefaultValue = this.myDefaultValueField.getText().trim();
        this.myResFolder = (VirtualFile)this.myResFolderCombo.getSelectedItem();
        super.doOKAction();
    }

    public String getKey() {
        return this.myKey;
    }

    public String getDefaultValue() {
        return this.myDefaultValue;
    }

    public VirtualFile getResFolder() {
        return this.myResFolder;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        EditorTextField editorTextField;
        EditorTextField editorTextField2;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Key:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Default Value:");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Resource Folder:");
        jPanel.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myResFolderCombo = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, new Dimension(250, -1), null, null));
        this.myKeyField = editorTextField2 = new EditorTextField();
        jPanel.add((Component)editorTextField2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myDefaultValueField = editorTextField = new EditorTextField();
        jPanel.add((Component)editorTextField, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

