/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation.macros;

import com.android.tools.idea.editors.navigation.macros.CodeTemplate;
import com.google.common.base.Objects;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.java.PsiIdentifierImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Unifier {
    private static final Logger LOG = Logger.getInstance((String)Unifier.class.getName());
    public static final PsiElement UNBOUND = new PsiIdentifierImpl((CharSequence)"<Unbound>");
    public static final String STATEMENT_SENTINEL = "$";
    public static final String STATEMENTS_SENTINEL = "$$";
    public static boolean DEBUG = false;
    private int indent = 0;

    public static Map<String, PsiElement> match(CodeTemplate template, PsiElement element) {
        return new Unifier().unify(template.getParameters(), template.getBody(), element);
    }

    private String indent() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.indent; ++i) {
            b.append("  ");
        }
        return b.toString();
    }

    public Map<String, PsiElement> unify(List<String> parameterList, PsiElement body, PsiElement candidate) {
        Matcher myMatcher = new Matcher(candidate);
        for (String parameter : parameterList) {
            myMatcher.bindings.put(parameter, UNBOUND);
        }
        body.accept((PsiElementVisitor)myMatcher);
        Map bindings = myMatcher.getBindings();
        if (DEBUG) {
            System.out.println("Unifier: bindings = " + bindings);
        }
        return bindings;
    }

    private class Matcher
    extends JavaElementVisitor {
        Map<String, PsiElement> bindings = new HashMap<String, PsiElement>();
        Map<String, String> parameterBindings = new HashMap<String, String>();
        private boolean valid = true;
        private PsiElement candidate;

        private Matcher(PsiElement candidate) {
            this.candidate = candidate;
        }

        private boolean equals(PsiIdentifier identifier1, PsiElement identifier2) {
            return identifier2 instanceof PsiIdentifier && identifier1.getText().equals(identifier2.getText());
        }

        public void visitParameter(PsiParameter parameter) {
            String name = parameter.getName();
            if (this.parameterBindings.get(name) != null) assert (false);
            this.parameterBindings.put(name, ((PsiParameter)this.candidate).getName());
        }

        private boolean isBindable(String text) {
            return this.bindings.containsKey(text) || this.parameterBindings.containsKey(text);
        }

        public void visitIdentifier(PsiIdentifier identifier) {
            String text = identifier.getText();
            if (this.isBindable(text)) {
                this.bindings.put(text, this.candidate);
            } else if (!this.equals(identifier, this.candidate)) {
                if (DEBUG) {
                    System.out.println(Unifier.this.indent() + identifier + " != " + this.candidate);
                }
                this.valid = false;
            }
        }

        public void visitAnnotation(PsiAnnotation annotation) {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            String targetName = expression.getFirstChild().getFirstChild().getText();
            String methodName = expression.getFirstChild().getLastChild().getText();
            if (methodName.equals(Unifier.STATEMENT_SENTINEL)) {
                this.bindings.put(targetName, this.candidate);
            } else {
                super.visitMethodCallExpression(expression);
            }
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            String text = expression.getText();
            if (this.isBindable(text)) {
                this.bindings.put(text, this.candidate);
            } else {
                this.visitReferenceElement((PsiJavaCodeReferenceElement)expression);
            }
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            if (reference != null && this.candidate instanceof PsiJavaCodeReferenceElement) {
                PsiJavaCodeReferenceElement other = (PsiJavaCodeReferenceElement)this.candidate;
                PsiElement simpleName1 = reference.getLastChild().getPrevSibling();
                PsiElement simpleName2 = this.candidate.getLastChild().getPrevSibling();
                if (simpleName1 instanceof LeafElement && simpleName2 instanceof LeafElement) {
                    LeafElement leaf1 = (LeafElement)simpleName1;
                    LeafElement leaf2 = (LeafElement)simpleName2;
                    if (leaf1.getChars().equals(leaf2.getChars())) {
                        PsiElement r1 = reference.resolve();
                        if (r1 == null) {
                            LOG.warn("Pattern contains unresolvable (unqualified?) class name: " + reference.getText());
                        }
                        PsiElement r2 = other.resolve();
                        if (r1 instanceof PsiClass && r2 instanceof PsiClass) {
                            PsiClass c1 = (PsiClass)r1;
                            PsiClass c2 = (PsiClass)r2;
                            if (Objects.equal((Object)c1.getQualifiedName(), (Object)c2.getQualifiedName())) {
                                return;
                            }
                        }
                    }
                }
            }
            super.visitReferenceElement(reference);
        }

        public void visitStatement(PsiStatement statement) {
            PsiElement expression = statement.getFirstChild();
            if (expression instanceof PsiMethodCallExpression) {
                String targetName = expression.getFirstChild().getFirstChild().getText();
                String methodName = expression.getFirstChild().getLastChild().getText();
                if (methodName.equals(Unifier.STATEMENTS_SENTINEL)) {
                    this.bindings.put(targetName, this.candidate.getParent());
                    this.candidate = this.candidate.getParent().getLastChild();
                    return;
                }
            }
            this.visitElement((PsiElement)statement);
        }

        public void visitElement(PsiElement template) {
            if (template.getClass() != this.candidate.getClass()) {
                if (DEBUG) {
                    System.out.println(Unifier.this.indent() + template + ".getClass() != " + this.candidate + ".getClass()");
                }
                if (DEBUG) {
                    System.out.println(Unifier.this.indent() + template.getClass() + " != " + this.candidate.getClass());
                }
                this.valid = false;
                return;
            }
            Unifier.this.indent++;
            PsiElement tmp = this.candidate;
            if (DEBUG) {
                System.out.println(Unifier.this.indent() + template + " : " + this.candidate);
            }
            PsiElement child = template.getFirstChild();
            this.candidate = this.candidate.getFirstChild();
            while (this.valid && child != null && this.candidate != null) {
                child.accept((PsiElementVisitor)this);
                child = child.getNextSibling();
                this.candidate = this.candidate.getNextSibling();
            }
            this.candidate = tmp;
            Unifier.this.indent--;
        }

        private Map<String, PsiElement> getBindings() {
            return this.valid ? this.bindings : null;
        }
    }
}

