/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.editors.navigation.macros.Analyser;
import com.android.tools.idea.rendering.RenderedView;
import com.intellij.psi.xml.XmlTag;

class HierarchyUtils {
    HierarchyUtils() {
    }

    static String getViewId(RenderedView leaf) {
        XmlTag tag;
        if (leaf != null && (tag = leaf.tag) != null) {
            String attributeValue = tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android");
            int prefixLength = Analyser.getPrefix(attributeValue).length();
            if (attributeValue != null && prefixLength != 0) {
                return attributeValue.substring(prefixLength);
            }
        }
        return null;
    }

    static RenderedView getRoot(RenderedView view) {
        RenderedView parent;
        while ((parent = view.getParent()) != null) {
            view = parent;
        }
        return view;
    }

    static RenderedView getNamedParent(RenderedView view) {
        while (view != null && HierarchyUtils.getViewId(view) == null) {
            view = view.getParent();
        }
        return view;
    }

    private static String getTagName(RenderedView leaf) {
        if (leaf != null && leaf.tag != null) {
            return leaf.tag.getName();
        }
        return "null";
    }

    private static String getClassName(ViewInfo leaf) {
        if (leaf != null) {
            return leaf.getViewObject().getClass().getSimpleName();
        }
        return "null";
    }

    private static String getClassName(RenderedView leaf) {
        if (leaf != null) {
            return HierarchyUtils.getClassName(leaf.view);
        }
        return "null";
    }

    private static void appendToBuilderIndented(RenderedView view, String indent, StringBuilder buffer) {
        buffer.append(indent + HierarchyUtils.getClassName(view) + " " + HierarchyUtils.getTagName(view) + " " + HierarchyUtils.getViewId(view) + "\n");
        for (RenderedView c : view.getChildren()) {
            HierarchyUtils.appendToBuilderIndented(c, "  " + indent, buffer);
        }
    }

    static String toString(RenderedView root) {
        if (root == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        HierarchyUtils.appendToBuilderIndented(root, "", buffer);
        return buffer.toString();
    }
}

