/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof.views;

import com.android.tools.idea.editors.hprof.views.GoToInstanceListener;
import com.android.tools.idea.editors.hprof.views.InstanceReferenceTreeView;
import com.android.tools.perflib.heap.Instance;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import javax.swing.JComponent;

public class GoToInstanceAction
extends AnAction {
    private final EventDispatcher<GoToInstanceListener> myEventDispatcher = EventDispatcher.create(GoToInstanceListener.class);

    public GoToInstanceAction(JComponent ancestorComponent) {
        super("Go to Instance");
        this.registerCustomShortcutSet(ActionManager.getInstance().getAction("GotoDeclaration").getShortcutSet(), ancestorComponent);
    }

    public void addListener(GoToInstanceListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(e.getData(InstanceReferenceTreeView.NAVIGATABLE_INSTANCE) != null);
    }

    public void actionPerformed(AnActionEvent e) {
        Instance instance = (Instance)e.getData(InstanceReferenceTreeView.NAVIGATABLE_INSTANCE);
        if (instance == null) {
            return;
        }
        for (GoToInstanceListener listener : this.myEventDispatcher.getListeners()) {
            listener.goToInstance(instance);
        }
    }
}

