/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.widgets;

import com.android.tools.idea.editors.gfxtrace.LoadingCallback;
import com.android.tools.idea.editors.gfxtrace.renderers.CellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class CellWidget<T extends Data, C extends JComponent>
extends JPanel {
    protected final C myComponent;
    protected final CellRenderer<T> myRenderer;
    private List<T> myData = Collections.emptyList();
    private AtomicBoolean myFireSelectionEvents = new AtomicBoolean(true);

    public CellWidget(C component, CellRenderer.CellLoader<T> loader) {
        super(new BorderLayout());
        this.myComponent = component;
        this.myRenderer = this.createCellRenderer(loader);
        this.add((Component)this.myComponent, "Center");
    }

    protected abstract CellRenderer<T> createCellRenderer(CellRenderer.CellLoader<T> var1);

    public CellRenderer<T> getRenderer() {
        return this.myRenderer;
    }

    public void addSelectionListener(final SelectionListener listener) {
        this.addSelectionListener(this.myComponent, new SelectionListener<T>(){

            @Override
            public void selected(T item) {
                if (CellWidget.this.myFireSelectionEvents.get()) {
                    listener.selected(item);
                }
            }
        });
    }

    protected abstract void addSelectionListener(C var1, SelectionListener<T> var2);

    public Iterable<T> items() {
        return this.myData;
    }

    public boolean isEmpty() {
        return this.myData.isEmpty();
    }

    public void setData(List<T> data) {
        this.myData = data;
    }

    public abstract int getSelectedItem();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectItem(int index, boolean fireEvents) {
        boolean previousValue = this.myFireSelectionEvents.getAndSet(fireEvents);
        try {
            this.setSelectedIndex(this.myComponent, index);
        }
        finally {
            this.myFireSelectionEvents.set(previousValue);
        }
    }

    protected abstract void setSelectedIndex(C var1, int var2);

    public static interface SelectionListener<T> {
        public void selected(T var1);
    }

    public static class Data
    implements LoadingCallback.LoadingDone {
        protected LoadingState loadingState = LoadingState.NOT_LOADED;
        public boolean isSelected = false;

        public boolean requiresLoading() {
            return this.loadingState == LoadingState.NOT_LOADED;
        }

        public boolean isLoading() {
            return this.loadingState == LoadingState.LOADING;
        }

        public boolean isLoaded() {
            return this.loadingState == LoadingState.LOADED;
        }

        public void startLoading() {
            this.loadingState = LoadingState.LOADING;
        }

        @Override
        public void stopLoading() {
            this.loadingState = LoadingState.LOADED;
        }

        protected static enum LoadingState {
            NOT_LOADED,
            LOADING,
            LOADED;

        }
    }
}

