/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service.atom;

import com.android.tools.idea.editors.gfxtrace.service.ApiID;
import com.android.tools.rpclib.binary.BinaryClass;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.binary.Namespace;
import com.android.tools.rpclib.schema.Array;
import com.android.tools.rpclib.schema.Entity;
import com.android.tools.rpclib.schema.Field;
import com.android.tools.rpclib.schema.Interface;
import com.android.tools.rpclib.schema.Primitive;
import com.android.tools.rpclib.schema.Slice;
import com.android.tools.rpclib.schema.Type;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;

public final class AtomMetadata
implements BinaryObject {
    boolean myIsPrepared = false;
    int myResultIndex = -1;
    int myExtrasIndex = -1;
    private static final Logger LOG = Logger.getInstance(AtomMetadata.class);
    private ApiID myAPI;
    private String myDisplayName;
    private boolean myEndOfFrame;
    private boolean myDrawCall;
    private String myDocumentationUrl;
    private static final Entity ENTITY = new Entity("atom", "Metadata", "", "");

    public static AtomMetadata find(Entity c) {
        for (BinaryObject o : c.getMetadata()) {
            if (!(o instanceof AtomMetadata)) continue;
            AtomMetadata meta = (AtomMetadata)o;
            meta.prepare(c);
            return meta;
        }
        return null;
    }

    private void prepare(Entity c) {
        if (this.myIsPrepared) {
            return;
        }
        this.myIsPrepared = true;
        for (int index = 0; index < c.getFields().length; ++index) {
            Type vt;
            Field field = c.getFields()[index];
            if (field.getDeclared().equals("Result")) {
                this.myResultIndex = index;
            }
            if (!(field.getType() instanceof Slice) || !((vt = ((Slice)field.getType()).getValueType()) instanceof Interface) || !"atom.Extra".equals(((Interface)vt).name)) continue;
            this.myExtrasIndex = index;
        }
    }

    public ApiID getAPI() {
        return this.myAPI;
    }

    public AtomMetadata setAPI(ApiID v) {
        this.myAPI = v;
        return this;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public AtomMetadata setDisplayName(String v) {
        this.myDisplayName = v;
        return this;
    }

    public boolean getEndOfFrame() {
        return this.myEndOfFrame;
    }

    public AtomMetadata setEndOfFrame(boolean v) {
        this.myEndOfFrame = v;
        return this;
    }

    public boolean getDrawCall() {
        return this.myDrawCall;
    }

    public AtomMetadata setDrawCall(boolean v) {
        this.myDrawCall = v;
        return this;
    }

    public String getDocumentationUrl() {
        return this.myDocumentationUrl;
    }

    public AtomMetadata setDocumentationUrl(String v) {
        this.myDocumentationUrl = v;
        return this;
    }

    public BinaryClass klass() {
        return Klass.INSTANCE;
    }

    public static void register() {
    }

    static {
        ENTITY.setFields(new Field[]{new Field("API", (Type)new Array("gfxapi.ID", (Type)new Primitive("byte", 2), 20)), new Field("DisplayName", (Type)new Primitive("string", 11)), new Field("EndOfFrame", (Type)new Primitive("bool", 0)), new Field("DrawCall", (Type)new Primitive("bool", 0)), new Field("DocumentationUrl", (Type)new Primitive("string", 11))});
        Namespace.register((BinaryClass)Klass.INSTANCE);
    }

    public static enum Klass implements BinaryClass
    {
        INSTANCE;


        public Entity entity() {
            return ENTITY;
        }

        public BinaryObject create() {
            return new AtomMetadata();
        }

        public void encode(Encoder e, BinaryObject obj) throws IOException {
            AtomMetadata o = (AtomMetadata)obj;
            o.myAPI.write(e);
            e.string(o.myDisplayName);
            e.bool(o.myEndOfFrame);
            e.bool(o.myDrawCall);
            e.string(o.myDocumentationUrl);
        }

        public void decode(Decoder d, BinaryObject obj) throws IOException {
            AtomMetadata o = (AtomMetadata)obj;
            o.myAPI = new ApiID(d);
            o.myDisplayName = d.string();
            o.myEndOfFrame = d.bool();
            o.myDrawCall = d.bool();
            o.myDocumentationUrl = d.string();
        }
    }
}

