/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.gapi;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.gapi.ChildProcess;
import com.android.tools.idea.editors.gfxtrace.gapi.GapiPaths;
import com.android.tools.idea.editors.gfxtrace.gapi.GapirProcess;
import com.android.tools.idea.editors.gfxtrace.gapi.GapisConnection;
import com.android.tools.idea.editors.gfxtrace.service.Factory;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class GapisProcess
extends ChildProcess {
    private static final Logger LOG = Logger.getInstance(GfxTraceEditor.class);
    private static final Object myInstanceLock = new Object();
    private static GapisProcess myInstance;
    private static final GapisConnection NOT_CONNECTED;
    private static final int SERVER_LAUNCH_TIMEOUT_MS = 10000;
    private static final String SERVER_HOST = "localhost";
    private final Set<GapisConnection> myConnections = Sets.newIdentityHashSet();
    private final GapirProcess myGapir = GapirProcess.get();
    private final SettableFuture<Integer> myPortF = this.start();

    private GapisProcess() {
        super("gapis");
    }

    @Override
    protected boolean prepare(ProcessBuilder pb) {
        if (!GapiPaths.isValid()) {
            LOG.warn("Could not find gapis, but needed to start the server.");
            return false;
        }
        pb.command(GapiPaths.gapis().getAbsolutePath(), "-logs", PathManager.getLogPath(), "--gapir", Integer.toString(this.myGapir.getPort()));
        return true;
    }

    @Override
    protected void onExit(int code) {
        if (code != 0) {
            LOG.warn("The gapis process exited with a non-zero exit value: " + code);
        } else {
            LOG.info("gapis exited cleanly");
        }
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GapisConnection connect() {
        GapisProcess gapis;
        Object object = myInstanceLock;
        synchronized (object) {
            if (myInstance == null) {
                myInstance = new GapisProcess();
            }
            gapis = myInstance;
        }
        return gapis.doConnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GapisConnection doConnect() {
        if (this.myPortF == null) {
            return NOT_CONNECTED;
        }
        try {
            int port = (Integer)this.myPortF.get(10000L, TimeUnit.MILLISECONDS);
            GapisConnection connection = new GapisConnection(this, new Socket(SERVER_HOST, port));
            LOG.info("Established a new client connection to " + port);
            Set<GapisConnection> set = this.myConnections;
            synchronized (set) {
                this.myConnections.add(connection);
            }
            return connection;
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for gapis: " + e);
        }
        catch (ExecutionException e) {
            LOG.warn("Failed while waiting for gapis: " + e);
        }
        catch (UnknownHostException e) {
            LOG.warn("Unknown host starting gapis: " + e);
        }
        catch (IOException e) {
            LOG.warn("Failed read from gapis: " + e);
        }
        catch (TimeoutException e) {
            LOG.warn("Timed out waiting for gapis: " + e);
        }
        return NOT_CONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(GapisConnection gapisConnection) {
        Set<GapisConnection> set = this.myConnections;
        synchronized (set) {
            this.myConnections.remove(gapisConnection);
            if (this.myConnections.isEmpty()) {
                LOG.info("Interrupting server thread on last connection close");
                this.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = myInstanceLock;
        synchronized (object) {
            if (myInstance == this) {
                myInstance = null;
                this.myGapir.shutdown();
                super.shutdown();
            }
        }
    }

    static {
        NOT_CONNECTED = new GapisConnection(null, null);
        Factory.register();
    }
}

