/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.LoadingCallback;
import com.android.tools.idea.editors.gfxtrace.controllers.ImageCellController;
import com.android.tools.idea.editors.gfxtrace.controllers.ImagePanelController;
import com.android.tools.idea.editors.gfxtrace.renderers.ImageCellRenderer;
import com.android.tools.idea.editors.gfxtrace.service.ResourceInfo;
import com.android.tools.idea.editors.gfxtrace.service.Resources;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.image.FetchedImage;
import com.android.tools.idea.editors.gfxtrace.service.image.Format;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.CapturePath;
import com.android.tools.idea.editors.gfxtrace.service.path.PathListener;
import com.android.tools.idea.editors.gfxtrace.service.path.PathStore;
import com.android.tools.idea.editors.gfxtrace.service.path.ResourcePath;
import com.android.tools.idea.editors.gfxtrace.service.path.ResourcesPath;
import com.android.tools.idea.editors.gfxtrace.service.path.ThumbnailPath;
import com.android.tools.idea.editors.gfxtrace.widgets.ImageCellList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.JComponent;

public class TexturesController
extends ImagePanelController {
    private static final Dimension DISPLAY_SIZE = new Dimension(8192, 8192);

    public static JComponent createUI(GfxTraceEditor editor) {
        return new TexturesController((GfxTraceEditor)editor).myPanel;
    }

    public TexturesController(GfxTraceEditor editor) {
        super(editor, "Select a frame or command");
        this.myPanel.add((Component)new DropDownController((GfxTraceEditor)editor){

            @Override
            public void selected(DropDownController.Data item) {
                TexturesController.this.setEmptyText(this.myList.isEmpty() ? "No textures have been created by this point" : "Select a texture");
                TexturesController.this.setImage(item == null ? null : FetchedImage.load(this.myEditor.getClient(), item.path.as(Format.RGBA)));
            }
        }.myList, "North");
        this.initToolbar(new DefaultActionGroup(), true);
    }

    @Override
    public void notifyPath(PathListener.PathEvent event) {
    }

    private static abstract class DropDownController
    extends ImageCellController<Data> {
        private static final Dimension CONTROL_SIZE = JBUI.size((int)100, (int)50);
        private static final Dimension REQUEST_SIZE = JBUI.size((int)100, (int)100);
        private static final Logger LOG = Logger.getInstance(TexturesController.class);
        private final PathStore<ResourcesPath> myResourcesPath = new PathStore();
        private final PathStore<AtomPath> myAtomPath = new PathStore();
        private Resources myResources;

        private DropDownController(GfxTraceEditor editor) {
            super(editor);
            this.usingComboBoxWidget(CONTROL_SIZE);
            ((ImageCellRenderer)this.myList.getRenderer()).setLayout(ImageCellRenderer.Layout.LEFT_TO_RIGHT);
        }

        @Override
        public void loadCell(Data cell, Runnable onLoad) {
            ServiceClient client = this.myEditor.getClient();
            ThumbnailPath path = cell.path.thumbnail(REQUEST_SIZE, Format.RGBA);
            this.loadCellImage(cell, client, path, onLoad);
        }

        protected void update(boolean resourcesChanged) {
            if (this.myAtomPath.getPath() != null && this.myResources != null) {
                ArrayList<Data> cells = new ArrayList<Data>();
                this.addTextures(cells, this.myResources.getTextures1D(), "1D");
                this.addTextures(cells, this.myResources.getTextures2D(), "2D");
                this.addTextures(cells, this.myResources.getTextures3D(), "3D");
                this.addTextures(cells, this.myResources.getCubemaps(), "Cubemap");
                int selectedIndex = this.myList.getSelectedItem();
                this.myList.setData(cells);
                if (!resourcesChanged && selectedIndex >= 0 && selectedIndex < cells.size()) {
                    this.myList.selectItem(selectedIndex, false);
                    this.selected(cells.get(selectedIndex));
                } else {
                    this.myList.selectItem(-1, false);
                    this.selected(null);
                }
            }
        }

        private void addTextures(List<Data> cells, ResourceInfo[] textures, String typeLabel) {
            AtomPath atomPath = this.myAtomPath.getPath();
            for (ResourceInfo info : textures) {
                if (info.getFirstAccess() > atomPath.getIndex()) continue;
                cells.add(new Data(info, typeLabel, atomPath.resourceAfter(info.getID())));
            }
        }

        @Override
        public void notifyPath(PathListener.PathEvent event) {
            if (this.myResourcesPath.updateIfNotNull(CapturePath.resources(event.findCapturePath()))) {
                Futures.addCallback(this.myEditor.getClient().get(this.myResourcesPath.getPath()), (FutureCallback)new LoadingCallback<Resources>(LOG){

                    public void onSuccess(Resources resources) {
                        DropDownController.this.myResources = resources;
                        DropDownController.this.update(true);
                    }
                }, (Executor)EdtExecutor.INSTANCE);
            }
            if (this.myAtomPath.updateIfNotNull(event.findAtomPath())) {
                this.update(false);
            }
        }

        public static class Data
        extends ImageCellList.Data {
            public final ResourceInfo info;
            public final ResourcePath path;

            public Data(ResourceInfo info, String typeLabel, ResourcePath path) {
                super(typeLabel + " " + info.getName());
                this.info = info;
                this.path = path;
            }
        }
    }
}

