/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.controllers.Controller;
import com.android.tools.idea.editors.gfxtrace.service.image.FetchedImage;
import com.android.tools.idea.editors.gfxtrace.widgets.ImagePanel;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public abstract class ImagePanelController
extends Controller {
    private static final Logger LOG = Logger.getInstance(ImagePanelController.class);
    protected final JPanel myPanel = new JPanel(new BorderLayout());
    private final LoadingDecorator myLoading;
    private final ImagePanel myImagePanel = new ImagePanel();
    private final AtomicInteger imageLoadCount = new AtomicInteger();
    private ListenableFuture<?> request = Futures.immediateFuture((Object)0);

    public ImagePanelController(GfxTraceEditor editor, String emptyText) {
        super(editor);
        this.myImagePanel.getEmptyText().setText(emptyText);
        this.myLoading = new LoadingDecorator(this.myImagePanel, (Disposable)this.myEditor.getProject(), -1){

            protected NonOpaquePanel customizeLoadingLayer(JPanel parent, JLabel text, AsyncProcessIcon icon) {
                NonOpaquePanel result = super.customizeLoadingLayer(parent, text, icon);
                result.setOpaque(true);
                result.setBackground(UIUtil.getPanelBackground());
                result.setBorder(JBUI.Borders.merge((Border)JBUI.Borders.customLine((Color)new JBColor(0, 0xFFFFFF), (int)1), (Border)JBUI.Borders.empty((int)5), (boolean)false));
                return result;
            }
        };
        this.myPanel.add((Component)this.myLoading.getComponent(), "Center");
    }

    protected void initToolbar(DefaultActionGroup group, boolean enableVerticalFlip) {
        this.myImagePanel.addToolbarActions(group, enableVerticalFlip);
        this.myPanel.add((Component)ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, false).getComponent(), "West");
    }

    protected void setEmptyText(String text) {
        this.myImagePanel.getEmptyText().setText(text);
    }

    protected void setImage(ListenableFuture<FetchedImage> imageFuture) {
        if (imageFuture == null) {
            this.myImagePanel.setImage(null);
            return;
        }
        final int imageRequest = this.newImageRequest(imageFuture);
        this.myLoading.startLoading(false);
        Futures.addCallback(imageFuture, (FutureCallback)new FutureCallback<FetchedImage>(){

            public void onSuccess(FetchedImage result) {
                ImagePanelController.this.updateImage(imageRequest, result);
            }

            public void onFailure(Throwable t) {
                if (!(t instanceof CancellationException)) {
                    LOG.error(t);
                }
                if (ImagePanelController.this.isCurrentImageRequest(imageRequest)) {
                    ImagePanelController.this.myLoading.stopLoading();
                }
            }
        }, (Executor)EdtExecutor.INSTANCE);
    }

    private void updateImage(int imageRequest, FetchedImage fetchedImage) {
        if (this.isCurrentImageRequest(imageRequest)) {
            this.myLoading.stopLoading();
            this.myImagePanel.setImage(fetchedImage.icon.getImage());
        }
    }

    private synchronized int newImageRequest(ListenableFuture<?> request) {
        this.request.cancel(true);
        this.request = request;
        return this.imageLoadCount.incrementAndGet();
    }

    private boolean isCurrentImageRequest(int request) {
        return this.imageLoadCount.get() == request;
    }
}

