/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.actions.FramebufferTypeAction;
import com.android.tools.idea.editors.gfxtrace.actions.FramebufferWireframeAction;
import com.android.tools.idea.editors.gfxtrace.controllers.ImagePanelController;
import com.android.tools.idea.editors.gfxtrace.service.RenderSettings;
import com.android.tools.idea.editors.gfxtrace.service.WireframeMode;
import com.android.tools.idea.editors.gfxtrace.service.image.FetchedImage;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.DevicePath;
import com.android.tools.idea.editors.gfxtrace.service.path.ImageInfoPath;
import com.android.tools.idea.editors.gfxtrace.service.path.PathListener;
import com.android.tools.idea.editors.gfxtrace.service.path.PathStore;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import icons.AndroidIcons;
import javax.swing.JComponent;

public class FrameBufferController
extends ImagePanelController {
    private static final int MAX_SIZE = 65535;
    private final PathStore<DevicePath> myRenderDevice = new PathStore();
    private final PathStore<AtomPath> myAtomPath = new PathStore();
    private final RenderSettings mySettings = new RenderSettings();
    private BufferType myBufferType = BufferType.Color;

    public static JComponent createUI(GfxTraceEditor editor) {
        return new FrameBufferController((GfxTraceEditor)editor).myPanel;
    }

    private FrameBufferController(GfxTraceEditor editor) {
        super(editor, "Select a frame or command");
        this.mySettings.setMaxHeight(65535);
        this.mySettings.setMaxWidth(65535);
        this.mySettings.setWireframeMode(WireframeMode.noWireframe());
        this.initToolbar(this.getToolbarActions(), false);
    }

    private DefaultActionGroup getToolbarActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new FramebufferTypeAction(this, BufferType.Color, "Color Buffer", "Display the color framebuffer", AndroidIcons.GfxTrace.ColorBuffer));
        group.add((AnAction)new FramebufferTypeAction(this, BufferType.Depth, "Depth Buffer", "Display the depth framebuffer", AndroidIcons.GfxTrace.DepthBuffer));
        group.add((AnAction)new Separator());
        group.add((AnAction)new FramebufferWireframeAction(this, WireframeMode.noWireframe(), "Shaded", "Display the framebuffer with shaded polygons", AndroidIcons.GfxTrace.WireframeNone));
        group.add((AnAction)new FramebufferWireframeAction(this, WireframeMode.wireframeOverlay(), "Shaded + Wireframe", "Display the framebuffer with shaded polygons and overlay the wireframe of the last draw call", AndroidIcons.GfxTrace.WireframeOverlay));
        group.add((AnAction)new FramebufferWireframeAction(this, WireframeMode.allWireframe(), "Wireframe", "Display the framebuffer with wireframes", AndroidIcons.GfxTrace.WireframeAll));
        group.add((AnAction)new Separator());
        return group;
    }

    public BufferType getBufferType() {
        return this.myBufferType;
    }

    public void setBufferType(BufferType bufferType) {
        if (!this.myBufferType.equals((Object)bufferType)) {
            this.myBufferType = bufferType;
            this.updateBuffer();
        }
    }

    public WireframeMode getWireframeMode() {
        return this.mySettings.getWireframeMode();
    }

    public void setWireframeMode(WireframeMode mode) {
        if (!this.mySettings.getWireframeMode().equals(mode)) {
            this.mySettings.setWireframeMode(mode);
            this.updateBuffer();
        }
    }

    @Override
    public void notifyPath(PathListener.PathEvent event) {
        boolean updateBuffer = this.myRenderDevice.updateIfNotNull(event.findDevicePath());
        updateBuffer = this.myAtomPath.updateIfNotNull(event.findAtomPath()) | updateBuffer;
        if (updateBuffer && this.myRenderDevice.getPath() != null && this.myAtomPath.getPath() != null) {
            this.updateBuffer();
        }
    }

    private void updateBuffer() {
        this.setImage(FetchedImage.load(this.myEditor.getClient(), this.getImageInfoPath()));
    }

    private ListenableFuture<ImageInfoPath> getImageInfoPath() {
        switch (this.myBufferType) {
            case Color: {
                return this.myEditor.getClient().getFramebufferColor(this.myRenderDevice.getPath(), this.myAtomPath.getPath(), this.mySettings);
            }
            case Depth: {
                return this.myEditor.getClient().getFramebufferDepth(this.myRenderDevice.getPath(), this.myAtomPath.getPath());
            }
        }
        return null;
    }

    public static enum BufferType {
        Color,
        Depth;

    }
}

