/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace;

import com.android.tools.idea.editors.gfxtrace.LoadingCallback;
import com.android.tools.idea.editors.gfxtrace.controllers.MainController;
import com.android.tools.idea.editors.gfxtrace.gapi.GapiPaths;
import com.android.tools.idea.editors.gfxtrace.gapi.GapisConnection;
import com.android.tools.idea.editors.gfxtrace.gapi.GapisProcess;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClientCache;
import com.android.tools.idea.editors.gfxtrace.service.atom.AtomMetadata;
import com.android.tools.idea.editors.gfxtrace.service.path.CapturePath;
import com.android.tools.idea.editors.gfxtrace.service.path.DevicePath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.service.path.PathListener;
import com.android.tools.idea.editors.gfxtrace.service.path.PathStore;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.schema.ConstantSet;
import com.android.tools.rpclib.schema.Dynamic;
import com.android.tools.rpclib.schema.Entity;
import com.android.tools.rpclib.schema.Message;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;

public class GfxTraceEditor
extends UserDataHolderBase
implements FileEditor {
    public static final String LOADING_CAPTURE = "Loading capture...";
    public static final String SELECT_ATOM = "Select a frame or command";
    public static final String SELECT_MEMORY = "Select a memory range in the command list";
    public static final String SELECT_TEXTURE = "Select a texture";
    public static final String NO_TEXTURES = "No textures have been created by this point";
    private static final Logger LOG = Logger.getInstance(GfxTraceEditor.class);
    private final Project myProject;
    private LoadingDecorator myLoadingDecorator;
    private JBPanel myView = new JBPanel((LayoutManager)new BorderLayout());
    private final ListeningExecutorService myExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
    private GapisConnection myGapisConnection;
    private ServiceClient myClient;
    private List<PathListener> myPathListeners = new ArrayList<PathListener>();
    private PathStore<Path> myLastActivatadPath = new PathStore();

    public static boolean isEnabled() {
        return true;
    }

    public GfxTraceEditor(Project project, final VirtualFile file) {
        this.myProject = project;
        this.myLoadingDecorator = new LoadingDecorator((JComponent)this.myView, (Disposable)this, 0);
        this.myLoadingDecorator.setLoadingText("Initializing GFX Trace System");
        this.myLoadingDecorator.startLoading(false);
        final JComponent mainUi = MainController.createUI(this);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                if (!GfxTraceEditor.isEnabled()) {
                    GfxTraceEditor.this.setLoadingErrorTextOnEdt("GFX Trace System not enabled on this host");
                    return;
                }
                if (!GapiPaths.isValid()) {
                    GfxTraceEditor.this.setLoadingErrorTextOnEdt("GPU debugging SDK not installed");
                    return;
                }
                if (!GfxTraceEditor.this.connectToServer()) {
                    GfxTraceEditor.this.setLoadingErrorTextOnEdt("Unable to connect to server");
                    return;
                }
                try {
                    GfxTraceEditor.this.myClient = new ServiceClientCache(GfxTraceEditor.this.myGapisConnection.createServiceClient(GfxTraceEditor.this.myExecutor));
                }
                catch (IOException e) {
                    GfxTraceEditor.this.setLoadingErrorTextOnEdt("Unable to talk to server");
                    return;
                }
                GfxTraceEditor.this.loadReplayDevice();
                ListenableFuture<Message> schemaF = GfxTraceEditor.this.myClient.getSchema();
                Futures.addCallback(schemaF, (FutureCallback)new LoadingCallback<Message>(LOG){

                    public void onSuccess(Message schema) {
                        LOG.info("Schema with " + schema.entities.length + " classes, " + schema.constants.length + " constant sets");
                        int atoms = 0;
                        for (Entity entity : schema.entities) {
                            if (AtomMetadata.find(entity) != null) {
                                ++atoms;
                            }
                            Dynamic.register((Entity)entity);
                        }
                        LOG.info("Schema with " + atoms + " atoms");
                        for (Entity entity : schema.constants) {
                            ConstantSet.register((ConstantSet)entity);
                        }
                    }
                });
                try {
                    ListenableFuture<CapturePath> captureF;
                    if (file.getFileSystem().getProtocol().equals("file")) {
                        LOG.info("Load gfxtrace in " + file.getPresentableName());
                        captureF = GfxTraceEditor.this.myClient.loadCapture(file.getCanonicalPath());
                    } else {
                        byte[] data = file.contentsToByteArray();
                        LOG.info("Upload " + data.length + " bytes of gfxtrace as " + file.getPresentableName());
                        captureF = GfxTraceEditor.this.myClient.importCapture(file.getPresentableName(), data);
                    }
                    Futures.addCallback((ListenableFuture)Futures.allAsList((ListenableFuture[])new ListenableFuture[]{schemaF, captureF}), (FutureCallback)new LoadingCallback<List<BinaryObject>>(LOG){

                        public void onSuccess(List<BinaryObject> all) {
                            CapturePath path = (CapturePath)all.get(1);
                            LOG.info("Capture uploaded");
                            if (path != null) {
                                GfxTraceEditor.this.activatePath(path, (Object)GfxTraceEditor.this);
                            } else {
                                LOG.error("Invalid capture file " + file.getPresentableName());
                            }
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    GfxTraceEditor.this.myView.add((Component)mainUi, (Object)"Center");
                                    GfxTraceEditor.this.myLoadingDecorator.stopLoading();
                                }
                            });
                        }
                    });
                }
                catch (IOException e) {
                    GfxTraceEditor.this.setLoadingErrorTextOnEdt("Error reading gfxtrace file");
                    return;
                }
            }
        });
    }

    public void loadReplayDevice() {
        Futures.addCallback(this.getClient().getDevices(), (FutureCallback)new LoadingCallback<DevicePath[]>(LOG){

            public void onSuccess(DevicePath[] devices) {
                if (devices != null && devices.length >= 1) {
                    GfxTraceEditor.this.activatePath(devices[0], (Object)GfxTraceEditor.this);
                } else {
                    JobScheduler.getScheduler().schedule(new Runnable(){

                        @Override
                        public void run() {
                            GfxTraceEditor.this.loadReplayDevice();
                        }
                    }, 500L, TimeUnit.MILLISECONDS);
                }
            }
        });
    }

    public Project getProject() {
        return this.myProject;
    }

    public JComponent getComponent() {
        return this.myLoadingDecorator.getComponent();
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    public String getName() {
        return "GfxTraceView";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activatePath(final Path path, final Object source) {
        PathStore<Path> pathStore = this.myLastActivatadPath;
        synchronized (pathStore) {
            if (!this.myLastActivatadPath.update(path)) {
                return;
            }
        }
        final PathListener.PathEvent event = new PathListener.PathEvent(path, source);
        Runnable eventDispatch = new Runnable(){

            @Override
            public void run() {
                LOG.info("Activate path " + path + ", source: " + source.getClass().getName());
                for (PathListener listener : GfxTraceEditor.this.myPathListeners) {
                    listener.notifyPath(event);
                }
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            eventDispatch.run();
        } else {
            application.invokeLater(eventDispatch);
        }
    }

    public void addPathListener(PathListener listener) {
        this.myPathListeners.add(listener);
    }

    public FileEditorState getState(FileEditorStateLevel level) {
        return FileEditorState.INSTANCE;
    }

    public void setState(FileEditorState state) {
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public ServiceClient getClient() {
        return this.myClient;
    }

    public ListeningExecutorService getExecutor() {
        return this.myExecutor;
    }

    public void dispose() {
        this.shutdown();
    }

    private boolean connectToServer() {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        this.myGapisConnection = GapisProcess.connect();
        return this.myGapisConnection.isConnected();
    }

    private void setLoadingErrorTextOnEdt(final String error) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                GfxTraceEditor.this.myLoadingDecorator.setLoadingText(error);
                GfxTraceEditor.this.myLoadingDecorator.startLoading(false);
            }
        });
    }

    private void shutdown() {
        if (this.myGapisConnection != null) {
            this.myGapisConnection.close();
            this.myGapisConnection = null;
        }
        this.myExecutor.shutdown();
    }
}

