/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.allocations;

import com.android.ddmlib.AllocationInfo;
import com.android.ddmlib.AllocationsParser;
import com.android.ddmlib.ByteBufferUtil;
import com.android.tools.idea.editors.allocations.AllocationsView;
import com.google.common.base.Throwables;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.BorderLayout;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class AllocationsEditor
implements FileEditor {
    private final JPanel myPanel = new JPanel(new BorderLayout());

    public AllocationsEditor(Project project, VirtualFile file) {
        this.parseAllocationsFileInBackground(project, file);
    }

    private void parseAllocationsFileInBackground(final Project project, final VirtualFile file) {
        final Task.Modal parseTask = new Task.Modal(project, "Parsing allocations file", false){
            private AllocationInfo[] myAllocations;
            private String myErrorMessage;

            public void run(ProgressIndicator indicator) {
                ByteBuffer data;
                indicator.setIndeterminate(true);
                File allocationsFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
                try {
                    data = ByteBufferUtil.mapFile((File)allocationsFile, (long)0L, (ByteOrder)ByteOrder.BIG_ENDIAN);
                }
                catch (IOException ex) {
                    this.myErrorMessage = "Error reading from allocations file " + allocationsFile.getAbsolutePath();
                    throw new ProcessCanceledException();
                }
                try {
                    this.myAllocations = AllocationsParser.parse((ByteBuffer)data);
                }
                catch (Throwable throwable) {
                    this.myErrorMessage = "Unexpected error while parsing allocations file: " + Throwables.getRootCause((Throwable)throwable).getMessage();
                    throw new ProcessCanceledException();
                }
            }

            public void onSuccess() {
                AllocationsView view = new AllocationsView(project, this.myAllocations);
                AllocationsEditor.this.myPanel.add(view.getComponent(), "Center");
            }

            public void onCancel() {
                Messages.showErrorDialog((Project)project, (String)this.myErrorMessage, (String)AllocationsEditor.this.getName());
            }
        };
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                parseTask.queue();
            }
        });
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    public String getName() {
        return "AllocationsView";
    }

    public FileEditorState getState(FileEditorStateLevel level) {
        return FileEditorState.INSTANCE;
    }

    public void setState(FileEditorState state) {
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }

    public <T> T getUserData(Key<T> key) {
        return null;
    }

    public <T> void putUserData(Key<T> key, T value) {
    }
}

