/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors;

import com.android.resources.ResourceType;
import com.android.tools.idea.model.ManifestInfo;
import com.intellij.codeInsight.ImportFilter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.android.facet.AndroidFacet;

public class AndroidImportFilter
extends ImportFilter {
    public boolean shouldUseFullyQualifiedName(PsiFile targetFile, String classQualifiedName) {
        if (classQualifiedName.equals("android.R") || classQualifiedName.startsWith("android.R.")) {
            return true;
        }
        int index = classQualifiedName.lastIndexOf(46);
        if (index == classQualifiedName.length() - 2 && classQualifiedName.charAt(index + 1) == 'R') {
            String pkg = AndroidImportFilter.getApplicationPackage(targetFile);
            if (pkg != null) {
                return !AndroidImportFilter.isResourceClassReference(classQualifiedName, pkg + ".R");
            }
        } else if (index > 2 && classQualifiedName.charAt(index - 1) == 'R' && classQualifiedName.charAt(index - 2) == '.') {
            return classQualifiedName.startsWith("android.R") || ResourceType.getEnum((String)classQualifiedName.substring(index + 1)) != null;
        }
        return false;
    }

    private static String getApplicationPackage(PsiFile targetFile) {
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)targetFile);
        if (facet != null) {
            return ManifestInfo.get(facet.getModule(), false).getPackage();
        }
        return null;
    }

    private static boolean isResourceClassReference(String reference, String resourceClass) {
        return reference.equals(resourceClass) || reference.startsWith(resourceClass + ".");
    }
}

