/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.designer;

import java.awt.Rectangle;

public class Insets {
    public static final Insets NONE = new Insets(0, 0, 0, 0);
    public final int left;
    public final int top;
    public final int right;
    public final int bottom;

    public Insets(int left, int top, int right, int bottom) {
        this.left = left;
        this.right = right;
        this.top = top;
        this.bottom = bottom;
    }

    public boolean isEmpty() {
        return this == NONE || this.left == 0 && this.top == 0 && this.right == 0 && this.bottom == 0;
    }

    public boolean subtractFrom(Rectangle bounds) {
        if (this.isEmpty()) {
            return false;
        }
        bounds.x -= this.left;
        bounds.width += this.left;
        bounds.y -= this.top;
        bounds.height += this.top;
        bounds.width += this.right;
        bounds.height += this.bottom;
        return true;
    }

    public boolean addTo(Rectangle bounds) {
        if (this.isEmpty()) {
            return false;
        }
        bounds.x += this.left;
        bounds.width -= this.left;
        bounds.y += this.top;
        bounds.height -= this.top;
        bounds.width -= this.right;
        bounds.height -= this.bottom;
        return true;
    }

    public String toString() {
        return "Margins [left=" + this.left + ", right=" + this.right + ", top=" + this.top + ", bottom=" + this.bottom + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Insets insets = (Insets)o;
        if (this.bottom != insets.bottom) {
            return false;
        }
        if (this.left != insets.left) {
            return false;
        }
        if (this.right != insets.right) {
            return false;
        }
        return this.top == insets.top;
    }

    public int hashCode() {
        int result = this.left;
        result = 31 * result + this.top;
        result = 31 * result + this.right;
        result = 31 * result + this.bottom;
        return result;
    }
}

