/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.designer;

import com.android.tools.idea.designer.AndroidVariationPaletteItem;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.designer.palette.PaletteItem;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum FillPolicy {
    NONE,
    BOTH,
    WIDTH,
    HEIGHT,
    OPPOSITE,
    WIDTH_IN_VERTICAL,
    HEIGHT_IN_HORIZONTAL;

    static Map<String, FillPolicy> ourNameToPolicy;

    public boolean fillHorizontally(boolean inVerticalContext) {
        return this == BOTH || this == WIDTH || inVerticalContext && (this == OPPOSITE || this == WIDTH_IN_VERTICAL);
    }

    public boolean fillVertically(boolean inVerticalContext) {
        return this == BOTH || this == HEIGHT || !inVerticalContext && (this == OPPOSITE || this == HEIGHT_IN_HORIZONTAL);
    }

    public static FillPolicy get(String fill) {
        FillPolicy fillPolicy = null;
        if (!fill.isEmpty()) {
            fillPolicy = ourNameToPolicy.get(fill);
        }
        if (fillPolicy == null) {
            fillPolicy = NONE;
        }
        return fillPolicy;
    }

    public static FillPolicy getFillPreference(RadViewComponent component) {
        AndroidVariationPaletteItem item;
        FillPolicy preference;
        PaletteItem paletteItem = component.getInitialPaletteItem();
        if (paletteItem instanceof AndroidVariationPaletteItem && (preference = (item = (AndroidVariationPaletteItem)paletteItem).getFillPolicy()) != null) {
            return preference;
        }
        return component.getMetaModel().getFillPolicy();
    }

    static {
        ourNameToPolicy = new HashMap<String, FillPolicy>();
        for (FillPolicy pref : FillPolicy.values()) {
            ourNameToPolicy.put(pref.toString().toLowerCase(Locale.US), pref);
        }
    }
}

